/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.knowledge.items;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.DimensionId;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletRarity;
import mcjty.rftoolsdim.modules.dimlets.data.DimletSettings;
import mcjty.rftoolsdim.modules.knowledge.KnowledgeModule;
import mcjty.rftoolsdim.modules.knowledge.data.KnowledgeKey;
import mcjty.rftoolsdim.modules.knowledge.data.KnowledgeManager;
import mcjty.rftoolsdim.setup.Registration;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;

public class LostKnowledgeItem
extends Item
implements ITooltipSettings {
    private final Lazy<TooltipBuilder> tooltipBuilder = () -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsdim.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"pattern", this::getPatternString), TooltipBuilder.parameter((String)"reason", s -> this.getReasonString((ItemStack)s) != null, this::getReasonString)});
    private final DimletRarity rarity;

    private String getReasonString(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("reason")) {
            return tag.func_74779_i("reason");
        }
        return null;
    }

    private String getPatternString(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("pattern")) {
            String pattern = tag.func_74779_i("pattern");
            KnowledgeKey kkey = new KnowledgeKey(pattern);
            return kkey.getRarity().name().toLowerCase() + " " + kkey.getType().name().toLowerCase();
        }
        return "<Unknown>";
    }

    public LostKnowledgeItem(DimletRarity rarity) {
        super(Registration.createStandardProperties());
        this.rarity = rarity;
    }

    public DimletRarity getRarity() {
        return this.rarity;
    }

    @Nullable
    public static KnowledgeKey getKnowledgeKey(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("pattern")) {
            String pattern = tag.func_74779_i("pattern");
            return new KnowledgeKey(pattern);
        }
        return null;
    }

    public void func_77624_a(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag flags) {
        super.func_77624_a(itemStack, world, list, flags);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(this.getRegistryName(), itemStack, list, flags);
    }

    public static ItemStack createUnresearchedLostKnowledge(DimletRarity rarity) {
        switch (rarity) {
            case COMMON: {
                return new ItemStack((IItemProvider)KnowledgeModule.COMMON_LOST_KNOWLEDGE.get());
            }
            case UNCOMMON: {
                return new ItemStack((IItemProvider)KnowledgeModule.UNCOMMON_LOST_KNOWLEDGE.get());
            }
            case RARE: {
                return new ItemStack((IItemProvider)KnowledgeModule.RARE_LOST_KNOWLEDGE.get());
            }
            case LEGENDARY: {
                return new ItemStack((IItemProvider)KnowledgeModule.LEGENDARY_LOST_KNOWLEDGE.get());
            }
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack createLostKnowledge(World world, DimletKey key) {
        KnowledgeKey kkey;
        DimletSettings settings = DimletDictionary.get().getSettings(key);
        if (settings != null && (kkey = KnowledgeManager.get().getKnowledgeKey(DimensionId.overworld().loadWorld(world).func_72905_C(), key)) != null) {
            DimletRarity rarity = settings.getRarity();
            return LostKnowledgeItem.createLostKnowledgeStack(world, rarity, kkey);
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack createRandomLostKnowledge(World world, DimletRarity rarity, Random random) {
        List<KnowledgeKey> patterns = KnowledgeManager.get().getKnownPatterns(world, rarity);
        if (patterns.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        KnowledgeKey kkey = patterns.get(random.nextInt(patterns.size()));
        return LostKnowledgeItem.createLostKnowledgeStack(world, rarity, kkey);
    }

    private static ItemStack createLostKnowledgeStack(World world, DimletRarity rarity, KnowledgeKey kkey) {
        LostKnowledgeItem item = LostKnowledgeItem.getKnowledgeItem(rarity);
        ItemStack result = new ItemStack((IItemProvider)item);
        result.func_196082_o().func_74778_a("pattern", kkey.serialize());
        String reason = KnowledgeManager.get().getReason(world, kkey);
        if (reason != null) {
            result.func_77978_p().func_74778_a("reason", reason);
        }
        return result;
    }

    private static LostKnowledgeItem getKnowledgeItem(DimletRarity rarity) {
        LostKnowledgeItem item = (LostKnowledgeItem)KnowledgeModule.COMMON_LOST_KNOWLEDGE.get();
        switch (rarity) {
            case COMMON: {
                item = (LostKnowledgeItem)KnowledgeModule.COMMON_LOST_KNOWLEDGE.get();
                break;
            }
            case UNCOMMON: {
                item = (LostKnowledgeItem)KnowledgeModule.UNCOMMON_LOST_KNOWLEDGE.get();
                break;
            }
            case RARE: {
                item = (LostKnowledgeItem)KnowledgeModule.RARE_LOST_KNOWLEDGE.get();
                break;
            }
            case LEGENDARY: {
                item = (LostKnowledgeItem)KnowledgeModule.LEGENDARY_LOST_KNOWLEDGE.get();
            }
        }
        return item;
    }
}

