/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.workbench.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.CapabilityInfusable;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.container.AutomationFilterItemHander;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.container.NoDirectionItemHander;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletRarity;
import mcjty.rftoolsdim.modules.dimlets.data.DimletTools;
import mcjty.rftoolsdim.modules.dimlets.items.DimletItem;
import mcjty.rftoolsdim.modules.essences.EssencesModule;
import mcjty.rftoolsdim.modules.essences.blocks.BiomeAbsorberTileEntity;
import mcjty.rftoolsdim.modules.essences.blocks.BlockAbsorberTileEntity;
import mcjty.rftoolsdim.modules.essences.blocks.FluidAbsorberTileEntity;
import mcjty.rftoolsdim.modules.knowledge.data.KnowledgeKey;
import mcjty.rftoolsdim.modules.knowledge.items.LostKnowledgeItem;
import mcjty.rftoolsdim.modules.workbench.WorkbenchConfig;
import mcjty.rftoolsdim.modules.workbench.WorkbenchModule;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;

public class ResearcherTileEntity
extends GenericTileEntity
implements ITickableTileEntity {
    public static int SLOT_IN = 0;
    public static int SLOT_OUT = 1;
    private int progress;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(2).slot(SlotDefinition.specific(ResearcherTileEntity::isResearchable).in(), "container", SLOT_IN, 64, 24).slot(SlotDefinition.generic().out(), "container", SLOT_OUT, 118, 24).playerSlots(10, 70));
    private final IInfusable infusable = new DefaultInfusable((TileEntity)this);
    private final LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> this.infusable);
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)WorkbenchConfig.RESEARCHER_MAXENERGY.get()).intValue(), (long)((Integer)WorkbenchConfig.RESEARCHER_ENERGY_INPUT_PERTICK.get()).intValue());
    private final LazyOptional<GenericEnergyStorage> energyHandler = LazyOptional.of(() -> this.energyStorage);
    private final NoDirectionItemHander items = this.createItemHandler();
    private final LazyOptional<AutomationFilterItemHander> itemHandler = LazyOptional.of(() -> new AutomationFilterItemHander(this.items));
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Knowledge Holder").containerSupplier((windowId, player) -> new GenericContainer((ContainerType)WorkbenchModule.CONTAINER_RESEARCHER.get(), windowId.intValue(), (ContainerFactory)CONTAINER_FACTORY.get(), this.func_174877_v(), (GenericTileEntity)this)).integerListener(Tools.holder(() -> this.progress, v -> {
        this.progress = v;
    })).energyHandler(() -> this.energyStorage).itemHandler(() -> this.items));
    public static VoxelShape SLAB = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0);

    public ResearcherTileEntity() {
        super((TileEntityType)WorkbenchModule.TYPE_RESEARCHER.get());
    }

    private static boolean isResearchable(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof LostKnowledgeItem) {
            KnowledgeKey key = LostKnowledgeItem.getKnowledgeKey(stack);
            return key == null;
        }
        if (item == EssencesModule.BLOCK_ABSORBER_ITEM.get()) {
            return true;
        }
        if (item == EssencesModule.FLUID_ABSORBER_ITEM.get()) {
            return true;
        }
        if (item == EssencesModule.BIOME_ABSORBER_ITEM.get()) {
            return true;
        }
        if (DimletItem.isReadyDimlet(stack)) {
            DimletKey dimletKey = DimletTools.getDimletKey(stack);
            if (dimletKey == null) {
                return false;
            }
            return dimletKey.getType().usesKnowledgeSystem();
        }
        return false;
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(ResearcherTileEntity::new).infusable().manualEntry(ManualHelper.create((String)"rftoolsdim:dimlets/researcher")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsdim.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()})){

            public RotationType getRotationType() {
                return RotationType.NONE;
            }

            public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
                return SLAB;
            }
        };
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack stack;
            if (!this.items.getStackInSlot(SLOT_OUT).func_190926_b()) {
                return;
            }
            long consume = (long)((float)((Integer)WorkbenchConfig.RESEARCHER_USE_PER_TICK.get()).intValue() / (1.0f + this.infusable.getInfusedFactor() / 3.0f));
            if (this.energyStorage.getEnergy() >= consume && !(stack = this.items.getStackInSlot(SLOT_IN)).func_190926_b()) {
                --this.progress;
                if (this.progress <= 0) {
                    this.progress = 0;
                    this.research();
                    this.markDirtyClient();
                }
                this.energyStorage.consumeEnergy(consume);
                this.markDirtyQuick();
            }
        }
    }

    public void research() {
        ItemStack stack = this.items.getStackInSlot(SLOT_IN);
        if (!stack.func_190926_b()) {
            Item item = stack.func_77973_b();
            if (item instanceof LostKnowledgeItem) {
                this.researchKnowledge((LostKnowledgeItem)item);
            } else if (item == EssencesModule.BLOCK_ABSORBER_ITEM.get()) {
                this.researchBlockAbsorber(stack);
            } else if (item == EssencesModule.FLUID_ABSORBER_ITEM.get()) {
                this.researchFluidAbsorber(stack);
            } else if (item == EssencesModule.BIOME_ABSORBER_ITEM.get()) {
                this.researchBiomeAbsorber(stack);
            } else if (DimletItem.isReadyDimlet(stack)) {
                this.researchDimlet(stack);
            }
        }
    }

    private void researchDimlet(ItemStack stack) {
        DimletKey key = DimletTools.getDimletKey(stack);
        if (key != null) {
            ItemStack researched = LostKnowledgeItem.createLostKnowledge(this.field_145850_b, key);
            this.items.setStackInSlot(SLOT_OUT, researched);
        }
        this.items.decrStackSize(SLOT_IN, 1);
    }

    private void researchBiomeAbsorber(ItemStack stack) {
        DimletKey key;
        String biomeId = BiomeAbsorberTileEntity.getBiome(stack);
        if (biomeId != null && !biomeId.isEmpty() && (key = DimletDictionary.get().getBiomeDimlet(biomeId)) != null) {
            int absorberProgress = BiomeAbsorberTileEntity.getProgress(stack);
            if (this.field_145850_b.func_201674_k().nextInt(100) < absorberProgress) {
                ItemStack researched = LostKnowledgeItem.createLostKnowledge(this.field_145850_b, key);
                this.items.setStackInSlot(SLOT_OUT, researched);
            }
        }
        this.items.decrStackSize(SLOT_IN, 1);
    }

    private void researchBlockAbsorber(ItemStack stack) {
        DimletKey key;
        String blockId = BlockAbsorberTileEntity.getBlock(stack);
        if (blockId != null && !blockId.isEmpty() && (key = DimletDictionary.get().getBlockDimlet(blockId)) != null) {
            int absorberProgress = BlockAbsorberTileEntity.getProgress(stack);
            if (this.field_145850_b.func_201674_k().nextInt(100) < absorberProgress) {
                ItemStack researched = LostKnowledgeItem.createLostKnowledge(this.field_145850_b, key);
                this.items.setStackInSlot(SLOT_OUT, researched);
            }
        }
        this.items.decrStackSize(SLOT_IN, 1);
    }

    private void researchFluidAbsorber(ItemStack stack) {
        DimletKey key;
        String fluidId = FluidAbsorberTileEntity.getFluid(stack);
        if (fluidId != null && !fluidId.isEmpty() && (key = DimletDictionary.get().getFluidDimlet(fluidId)) != null) {
            int absorberProgress = FluidAbsorberTileEntity.getProgress(stack);
            if (this.field_145850_b.func_201674_k().nextInt(100) < absorberProgress) {
                ItemStack researched = LostKnowledgeItem.createLostKnowledge(this.field_145850_b, key);
                this.items.setStackInSlot(SLOT_OUT, researched);
            }
        }
        this.items.decrStackSize(SLOT_IN, 1);
    }

    private void researchKnowledge(LostKnowledgeItem item) {
        DimletRarity rarity = item.getRarity();
        ItemStack researched = LostKnowledgeItem.createRandomLostKnowledge(this.field_145850_b, rarity, this.field_145850_b.func_201674_k());
        this.items.setStackInSlot(SLOT_OUT, researched);
        if (!this.items.getStackInSlot(SLOT_IN).func_190926_b()) {
            this.progress = this.getMaxProgress();
        }
        this.items.decrStackSize(SLOT_IN, 1);
    }

    public int getProgress() {
        return this.progress;
    }

    public int getProgressPercentage() {
        int max = this.getMaxProgress();
        return (max - this.progress) * 100 / max;
    }

    private int getMaxProgress() {
        int p = (Integer)WorkbenchConfig.RESEARCH_TIME.get();
        return (int)((float)p / (1.0f + this.infusable.getInfusedFactor()));
    }

    public void read(CompoundNBT tagCompound) {
        super.read(tagCompound);
        this.progress = tagCompound.func_74762_e("progress");
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        tagCompound.func_74768_a("progress", this.progress);
        return super.func_189515_b(tagCompound);
    }

    private NoDirectionItemHander createItemHandler() {
        return new NoDirectionItemHander(this, (ContainerFactory)CONTAINER_FACTORY.get()){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return ResearcherTileEntity.isResearchable(stack);
            }

            public boolean isItemInsertable(int slot, @Nonnull ItemStack stack) {
                if (slot == SLOT_OUT) {
                    return false;
                }
                return this.isItemValid(slot, stack);
            }

            protected void onUpdate(int index) {
                super.onUpdate(index);
                if (index == SLOT_IN) {
                    ResearcherTileEntity.this.progress = ResearcherTileEntity.this.getMaxProgress();
                }
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyHandler.cast();
        }
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        if (cap == CapabilityInfusable.INFUSABLE_CAPABILITY) {
            return this.infusableHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

