/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import slimeknights.mantle.client.screen.ModuleScreen;
import slimeknights.mantle.inventory.MultiModuleContainer;
import slimeknights.mantle.inventory.WrapperSlot;

public class MultiModuleScreen<CONTAINER extends MultiModuleContainer<?>>
extends ContainerScreen<CONTAINER> {
    protected List<ModuleScreen<?, ?>> modules = Lists.newArrayList();
    public int cornerX;
    public int cornerY;
    public int realWidth = -1;
    public int realHeight = -1;

    public MultiModuleScreen(CONTAINER container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.field_230711_n_ = true;
    }

    protected void addModule(ModuleScreen<?, ?> module) {
        this.modules.add(module);
    }

    public List<Rectangle2d> getModuleAreas() {
        ArrayList<Rectangle2d> areas = new ArrayList<Rectangle2d>(this.modules.size());
        for (ModuleScreen<?, ?> module : this.modules) {
            areas.add(module.getArea());
        }
        return areas;
    }

    public void func_231160_c_() {
        if (this.realWidth > -1) {
            this.field_146999_f = this.realWidth;
            this.field_147000_g = this.realHeight;
        }
        super.func_231160_c_();
        this.cornerX = this.field_147003_i;
        this.cornerY = this.field_147009_r;
        this.realWidth = this.field_146999_f;
        this.realHeight = this.field_147000_g;
        for (ModuleScreen<?, ?> module : this.modules) {
            this.updateSubmodule(module);
        }
    }

    public void func_231158_b_(Minecraft mc, int width, int height) {
        super.func_231158_b_(mc, width, height);
        for (ModuleScreen<?, ?> module : this.modules) {
            module.func_231158_b_(mc, width, height);
            this.updateSubmodule(module);
        }
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        for (ModuleScreen<?, ?> module : this.modules) {
            module.handleDrawGuiContainerBackgroundLayer(matrixStack, partialTicks, mouseX, mouseY);
        }
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.drawContainerName(matrixStack);
        this.drawPlayerInventoryName(matrixStack);
        for (ModuleScreen<?, ?> module : this.modules) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(module.field_147003_i - this.field_147003_i), (double)(module.field_147009_r - this.field_147009_r), 0.0);
            module.handleDrawGuiContainerForegroundLayer(matrixStack, mouseX, mouseY);
            matrixStack.func_227865_b_();
        }
    }

    protected void func_230459_a_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230459_a_(matrixStack, mouseX, mouseY);
        for (ModuleScreen<?, ?> module : this.modules) {
            module.handleRenderHoveredTooltip(matrixStack, mouseX, mouseY);
        }
    }

    protected void drawBackground(MatrixStack matrixStack, ResourceLocation background) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(background);
        this.func_238474_b_(matrixStack, this.cornerX, this.cornerY, 0, 0, this.realWidth, this.realHeight);
    }

    protected void drawContainerName(MatrixStack matrixStack) {
        this.field_230712_o_.func_238422_b_(matrixStack, this.func_231171_q_().func_241878_f(), 8.0f, 6.0f, 0x404040);
    }

    protected void drawPlayerInventoryName(MatrixStack matrixStack) {
        assert (Minecraft.func_71410_x().field_71439_g != null);
        ITextComponent localizedName = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_145748_c_();
        this.field_230712_o_.func_238422_b_(matrixStack, localizedName.func_241878_f(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
    }

    public void func_231152_a_(Minecraft mc, int width, int height) {
        super.func_231152_a_(mc, width, height);
        for (ModuleScreen<?, ?> module : this.modules) {
            module.func_231152_a_(mc, width, height);
            this.updateSubmodule(module);
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        int oldX = this.field_147003_i;
        int oldY = this.field_147009_r;
        int oldW = this.field_146999_f;
        int oldH = this.field_147000_g;
        this.field_147003_i = this.cornerX;
        this.field_147009_r = this.cornerY;
        this.field_146999_f = this.realWidth;
        this.field_147000_g = this.realHeight;
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        this.field_147003_i = oldX;
        this.field_147009_r = oldY;
        this.field_146999_f = oldW;
        this.field_147000_g = oldH;
    }

    protected boolean func_195359_a(int left, int top, int right, int bottom, double pointX, double pointY) {
        return (pointX -= (double)this.cornerX) >= (double)(left - 1) && pointX < (double)(left + right + 1) && (pointY -= (double)this.cornerY) >= (double)(top - 1) && pointY < (double)(top + bottom + 1);
    }

    protected void updateSubmodule(ModuleScreen<?, ?> module) {
        module.updatePosition(this.cornerX, this.cornerY, this.realWidth, this.realHeight);
        if (module.field_147003_i < this.field_147003_i) {
            this.field_146999_f += this.field_147003_i - module.field_147003_i;
            this.field_147003_i = module.field_147003_i;
        }
        if (module.field_147009_r < this.field_147009_r) {
            this.field_147000_g += this.field_147009_r - module.field_147009_r;
            this.field_147009_r = module.field_147009_r;
        }
        if (module.guiRight() > this.field_147003_i + this.field_146999_f) {
            this.field_146999_f = module.guiRight() - this.field_147003_i;
        }
        if (module.guiBottom() > this.field_147009_r + this.field_147000_g) {
            this.field_147000_g = module.guiBottom() - this.field_147009_r;
        }
    }

    public void func_238746_a_(MatrixStack matrixStack, Slot slotIn) {
        ModuleScreen<?, ?> module = this.getModuleForSlot(slotIn.field_75222_d);
        if (module != null) {
            Slot slot = slotIn;
            if (slotIn instanceof WrapperSlot) {
                slot = ((WrapperSlot)slotIn).parent;
            }
            if (!module.shouldDrawSlot(slot)) {
                return;
            }
        }
        if (slotIn instanceof WrapperSlot) {
            slotIn.field_75223_e = ((WrapperSlot)slotIn).parent.field_75223_e;
            slotIn.field_75221_f = ((WrapperSlot)slotIn).parent.field_75221_f;
        }
        super.func_238746_a_(matrixStack, slotIn);
    }

    public boolean func_195362_a(Slot slotIn, double mouseX, double mouseY) {
        ModuleScreen<?, ?> module = this.getModuleForSlot(slotIn.field_75222_d);
        if (module != null) {
            Slot slot = slotIn;
            if (slotIn instanceof WrapperSlot) {
                slot = ((WrapperSlot)slotIn).parent;
            }
            if (!module.shouldDrawSlot(slot)) {
                return false;
            }
        }
        return super.func_195362_a(slotIn, mouseX, mouseY);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        ModuleScreen<?, ?> module = this.getModuleForPoint(mouseX, mouseY);
        if (module != null && module.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return false;
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int clickedMouseButton, double timeSinceLastClick, double unkowwn) {
        ModuleScreen<?, ?> module = this.getModuleForPoint(mouseX, mouseY);
        if (module != null && module.handleMouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick)) {
            return false;
        }
        return super.func_231045_a_(mouseX, mouseY, clickedMouseButton, timeSinceLastClick, unkowwn);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        ModuleScreen<?, ?> module = this.getModuleForPoint(mouseX, mouseY);
        if (module != null && module.handleMouseScrolled(mouseX, mouseY, delta)) {
            return false;
        }
        return super.func_231043_a_(mouseX, mouseY, delta);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int state) {
        ModuleScreen<?, ?> module = this.getModuleForPoint(mouseX, mouseY);
        if (module != null && module.handleMouseReleased(mouseX, mouseY, state)) {
            return false;
        }
        return super.func_231048_c_(mouseX, mouseY, state);
    }

    @Nullable
    protected ModuleScreen<?, ?> getModuleForPoint(double x, double y) {
        for (ModuleScreen<?, ?> module : this.modules) {
            if (!this.func_195359_a(module.field_147003_i, module.field_147009_r, module.guiRight(), module.guiBottom(), x + (double)this.cornerX, y + (double)this.cornerY)) continue;
            return module;
        }
        return null;
    }

    @Nullable
    protected ModuleScreen<?, ?> getModuleForSlot(int slotNumber) {
        return this.getModuleForContainer(((MultiModuleContainer)((Object)this.getContainer())).getSlotContainer(slotNumber));
    }

    @Nullable
    protected ModuleScreen<?, ?> getModuleForContainer(Container container) {
        for (ModuleScreen<?, ?> module : this.modules) {
            if (module.func_212873_a_() != container) continue;
            return module;
        }
        return null;
    }

    public CONTAINER getContainer() {
        return (CONTAINER)((Object)((MultiModuleContainer)this.field_147002_h));
    }
}

