/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.client.screen.MultiModuleScreen;
import slimeknights.mantle.client.screen.Widget;

@OnlyIn(value=Dist.CLIENT)
public class TabsWidget
extends Widget {
    private static final ResourceLocation creativeInventoryTabs = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private final ElementScreen[] tabActive = new ElementScreen[3];
    private final ElementScreen[] tab = new ElementScreen[3];
    public ResourceLocation tabsResource = creativeInventoryTabs;
    public int yOffset = 4;
    public int spacing = 2;
    public int selected;
    public int highlighted;
    protected List<ItemStack> icons = Lists.newArrayList();
    private final MultiModuleScreen parent;
    private boolean clicked = false;
    private boolean leftMouseDown = false;

    public TabsWidget(MultiModuleScreen parent, ElementScreen tabLeft, ElementScreen tabCenter, ElementScreen tabRight, ElementScreen activeLeft, ElementScreen activeCenter, ElementScreen activeRight) {
        this.parent = parent;
        this.tab[0] = tabLeft;
        this.tab[1] = tabCenter;
        this.tab[2] = tabRight;
        this.tabActive[0] = activeLeft;
        this.tabActive[1] = activeCenter;
        this.tabActive[2] = activeRight;
        this.selected = 0;
    }

    public void addTab(ItemStack icon) {
        this.icons.add(icon);
    }

    public void clear() {
        this.selected = 0;
        this.icons.clear();
    }

    @Override
    public void handleMouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.leftMouseDown = true;
        }
    }

    @Override
    public void handleMouseReleased() {
        this.leftMouseDown = false;
    }

    public void update(int mouseX, int mouseY) {
        mouseX -= this.xPos;
        this.highlighted = -1;
        if ((mouseY -= this.yPos) >= 0 && mouseY <= this.tab[1].h) {
            int x = 0;
            for (int i = 0; i < this.icons.size(); ++i) {
                if (mouseX >= x && mouseX < x + this.tab[1].w) {
                    this.highlighted = i;
                    break;
                }
                x += this.tab[1].w;
                x += this.spacing;
            }
        }
        if (this.clicked) {
            if (!this.leftMouseDown) {
                this.clicked = false;
            }
            return;
        }
        if (!this.leftMouseDown) {
            return;
        }
        this.clicked = true;
        if (this.highlighted > -1) {
            this.selected = this.highlighted;
        }
    }

    @Override
    public void draw(MatrixStack matrixStack) {
        int y = this.yPos + this.yOffset;
        for (int i = 0; i < this.icons.size(); ++i) {
            int x = this.xPos + i * this.tab[0].w;
            if (i > 0) {
                x += i * this.spacing;
            }
            ElementScreen[] toDraw = i == this.selected ? this.tabActive : this.tab;
            ElementScreen actualTab = i == 0 && x == this.parent.cornerX ? toDraw[0] : (x == this.parent.cornerX + this.parent.field_230708_k_ ? toDraw[2] : toDraw[1]);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.tabsResource);
            actualTab.draw(matrixStack, x, y);
            ItemStack icon = this.icons.get(i);
            if (icon == null) continue;
            this.drawItemStack(icon, x + (actualTab.w - 16) / 2, y + (actualTab.h - 16) / 2);
            RenderHelper.func_74518_a();
        }
    }

    private void drawItemStack(ItemStack stack, int x, int y) {
        ItemRenderer itemRender = Minecraft.func_71410_x().func_175599_af();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)32.0f);
        itemRender.field_77023_b = 200.0f;
        itemRender.func_180450_b(stack, x, y);
        itemRender.field_77023_b = 0.0f;
    }
}

