/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import slimeknights.mantle.item.RetexturedBlockItem;
import slimeknights.mantle.recipe.MantleRecipeSerializers;
import slimeknights.mantle.util.JsonHelper;

public class ShapedRetexturedRecipe
extends ShapedRecipe {
    private final Ingredient texture;
    private final boolean matchAll;

    protected ShapedRetexturedRecipe(ShapedRecipe orig, Ingredient texture, boolean matchAll) {
        super(orig.func_199560_c(), orig.func_193358_e(), orig.func_192403_f(), orig.func_192404_g(), orig.func_192400_c(), orig.func_77571_b());
        this.texture = texture;
        this.matchAll = matchAll;
    }

    public ItemStack getRecipeOutput(Item texture) {
        return RetexturedBlockItem.setTexture(this.func_77571_b().func_77946_l(), Block.func_149634_a((Item)texture));
    }

    public ItemStack func_77572_b(CraftingInventory craftMatrix) {
        ItemStack result = super.func_77572_b(craftMatrix);
        Block currentTexture = null;
        for (int i = 0; i < craftMatrix.func_70302_i_(); ++i) {
            Block block;
            ItemStack stack = craftMatrix.func_70301_a(i);
            if (stack.func_190926_b() || !this.texture.test(stack) || (block = stack.func_77973_b() == result.func_77973_b() ? RetexturedBlockItem.getTexture(stack) : Block.func_149634_a((Item)stack.func_77973_b())) == Blocks.field_150350_a) continue;
            if (currentTexture == null) {
                currentTexture = block;
                if (this.matchAll) continue;
                break;
            }
            if (currentTexture == block) continue;
            currentTexture = null;
            break;
        }
        if (currentTexture != null) {
            return RetexturedBlockItem.setTexture(result, currentTexture);
        }
        return result;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return MantleRecipeSerializers.CRAFTING_SHAPED_RETEXTURED;
    }

    public Ingredient getTexture() {
        return this.texture;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ShapedRetexturedRecipe> {
        public ShapedRetexturedRecipe read(ResourceLocation recipeId, JsonObject json) {
            ShapedRecipe recipe = (ShapedRecipe)field_222157_a.func_199425_a_(recipeId, json);
            Ingredient texture = CraftingHelper.getIngredient((JsonElement)JsonHelper.getElement(json, "texture"));
            boolean matchAll = false;
            if (json.has("match_all")) {
                matchAll = json.get("match_all").getAsBoolean();
            }
            return new ShapedRetexturedRecipe(recipe, texture, matchAll);
        }

        @Nullable
        public ShapedRetexturedRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            ShapedRecipe recipe = (ShapedRecipe)field_222157_a.func_199426_a_(recipeId, buffer);
            return recipe == null ? null : new ShapedRetexturedRecipe(recipe, Ingredient.func_199566_b((PacketBuffer)buffer), buffer.readBoolean());
        }

        public void write(PacketBuffer buffer, ShapedRetexturedRecipe recipe) {
            field_222157_a.func_199427_a_(buffer, (IRecipe)recipe);
            recipe.texture.func_199564_a(buffer);
            buffer.writeBoolean(recipe.matchAll);
        }
    }
}

