/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.adapter;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.StandingSignBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.WallSignBlock;
import net.minecraft.block.WoodButtonBlock;
import net.minecraft.block.WoodType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.block.StrippableLogBlock;
import slimeknights.mantle.block.WoodenDoorBlock;
import slimeknights.mantle.registration.RegistrationHelper;
import slimeknights.mantle.registration.adapter.EnumRegistryAdapter;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.FenceBuildingBlockObject;
import slimeknights.mantle.registration.object.WallBuildingBlockObject;
import slimeknights.mantle.registration.object.WoodBlockObject;

public class BlockRegistryAdapter
extends EnumRegistryAdapter<Block> {
    public BlockRegistryAdapter(IForgeRegistry<Block> registry) {
        super(registry);
    }

    public BlockRegistryAdapter(IForgeRegistry<Block> registry, String modid) {
        super(registry, modid);
    }

    public <T extends Block> T registerOverride(Function<AbstractBlock.Properties, T> constructor, Block base) {
        return (T)((Block)this.register((IForgeRegistryEntry)constructor.apply(AbstractBlock.Properties.func_200950_a((AbstractBlock)base)), (IForgeRegistryEntry<?>)base));
    }

    public BuildingBlockObject registerBuilding(Block block, String name) {
        return new BuildingBlockObject(this.register(block, name), (Block)this.register(new SlabBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)block)), name + "_slab"), (Block)this.register(new StairsBlock(() -> ((Block)block).func_176223_P(), AbstractBlock.Properties.func_200950_a((AbstractBlock)block)), name + "_stairs"));
    }

    public WallBuildingBlockObject registerWallBuilding(Block block, String name) {
        return new WallBuildingBlockObject(this.registerBuilding(block, name), (Block)this.register(new WallBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)block)), name + "_wall"));
    }

    public FenceBuildingBlockObject registerFenceBuilding(Block block, String name) {
        return new FenceBuildingBlockObject(this.registerBuilding(block, name), (Block)this.register(new FenceBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)block)), name + "_fence"));
    }

    public WoodBlockObject registerWood(String name, Material planksMaterial, MaterialColor planksColor, SoundType plankSound, ToolType planksTool, Material barkMaterial, MaterialColor barkColor, SoundType barkSound, ItemGroup group) {
        WoodType woodType = WoodType.create((String)this.resourceName(name));
        RegistrationHelper.registerWoodType(woodType);
        Item.Properties itemProps = new Item.Properties().func_200916_a(group);
        AbstractBlock.Properties planksProps = AbstractBlock.Properties.func_200949_a((Material)planksMaterial, (MaterialColor)planksColor).harvestTool(planksTool).func_200948_a(2.0f, 3.0f).func_200947_a(plankSound);
        BuildingBlockObject planks = this.registerBuilding(new Block(planksProps), name + "_planks");
        FenceBlock fence = this.register(new FenceBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)planks.get()))), name + "_fence");
        Supplier<RotatedPillarBlock> stripped = () -> new RotatedPillarBlock(AbstractBlock.Properties.func_200949_a((Material)planksMaterial, (MaterialColor)planksColor).harvestTool(planksTool).func_200943_b(2.0f).func_200947_a(plankSound));
        RotatedPillarBlock strippedLog = (RotatedPillarBlock)this.register((IForgeRegistryEntry)stripped.get(), "stripped_" + name + "_log");
        RotatedPillarBlock strippedWood = (RotatedPillarBlock)this.register((IForgeRegistryEntry)stripped.get(), "stripped_" + name + "_wood");
        RotatedPillarBlock log = this.register(new StrippableLogBlock((Supplier<? extends Block>)strippedLog.delegate, AbstractBlock.Properties.func_235836_a_((Material)barkMaterial, state -> state.func_177229_b((Property)RotatedPillarBlock.field_176298_M) == Direction.Axis.Y ? planksColor : barkColor).harvestTool(ToolType.AXE).func_200943_b(2.0f).func_200947_a(barkSound)), name + "_log");
        RotatedPillarBlock wood = this.register(new StrippableLogBlock((Supplier<? extends Block>)strippedWood.delegate, AbstractBlock.Properties.func_200949_a((Material)barkMaterial, (MaterialColor)barkColor).harvestTool(ToolType.AXE).func_200943_b(2.0f).func_200947_a(barkSound)), name + "_wood");
        DoorBlock door = this.register(new WoodenDoorBlock(AbstractBlock.Properties.func_200949_a((Material)planksMaterial, (MaterialColor)planksColor).harvestTool(planksTool).func_200943_b(3.0f).func_200947_a(plankSound).func_226896_b_()), name + "_door");
        TrapDoorBlock trapdoor = this.register(new TrapDoorBlock(AbstractBlock.Properties.func_200949_a((Material)planksMaterial, (MaterialColor)planksColor).harvestTool(planksTool).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235827_a_(Blocks::func_235427_a_)), name + "_trapdoor");
        FenceGateBlock fenceGate = this.register(new FenceGateBlock(planksProps), name + "_fence_gate");
        AbstractBlock.Properties redstoneProps = AbstractBlock.Properties.func_200949_a((Material)planksMaterial, (MaterialColor)planksColor).harvestTool(planksTool).func_200942_a().func_200943_b(0.5f).func_200947_a(plankSound);
        PressurePlateBlock pressurePlate = this.register(new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, redstoneProps), name + "_pressure_plate");
        WoodButtonBlock button = this.register(new WoodButtonBlock(redstoneProps), name + "_button");
        StandingSignBlock standingSign = this.register(new StandingSignBlock(AbstractBlock.Properties.func_200949_a((Material)planksMaterial, (MaterialColor)planksColor).func_200942_a().func_200943_b(1.0f).func_200947_a(plankSound), woodType), name + "_sign");
        WallSignBlock wallSign = this.register(new WallSignBlock(AbstractBlock.Properties.func_200949_a((Material)planksMaterial, (MaterialColor)planksColor).func_200942_a().func_200943_b(1.0f).func_200947_a(plankSound).lootFrom((Supplier)standingSign.delegate), woodType), name + "_wall_sign");
        RegistrationHelper.registerSignBlock((Supplier<? extends Block>)standingSign.delegate);
        RegistrationHelper.registerSignBlock((Supplier<? extends Block>)wallSign.delegate);
        return new WoodBlockObject(this.getResource(name), woodType, planks, (Block)log, (Block)strippedLog, (Block)wood, (Block)strippedWood, (Block)fence, (Block)fenceGate, (Block)door, (Block)trapdoor, (Block)pressurePlate, (Block)button, (Block)standingSign, (Block)wallSign);
    }

    public FlowingFluidBlock registerFluidBlock(Supplier<? extends ForgeFlowingFluid> fluid, Material material, int lightLevel, String name) {
        return this.register(new FlowingFluidBlock(fluid, AbstractBlock.Properties.func_200945_a((Material)material).func_200942_a().func_200943_b(100.0f).func_222380_e().func_235838_a_(state -> lightLevel)), name + "_fluid");
    }
}

