/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.deferred;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.StandingSignBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.WallSignBlock;
import net.minecraft.block.WoodButtonBlock;
import net.minecraft.block.WoodType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SignItem;
import net.minecraft.item.TallBlockItem;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.mantle.block.StrippableLogBlock;
import slimeknights.mantle.block.WoodenDoorBlock;
import slimeknights.mantle.item.BurnableBlockItem;
import slimeknights.mantle.item.BurnableSignItem;
import slimeknights.mantle.item.BurnableTallBlockItem;
import slimeknights.mantle.registration.RegistrationHelper;
import slimeknights.mantle.registration.deferred.DeferredRegisterWrapper;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.FenceBuildingBlockObject;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.mantle.registration.object.WallBuildingBlockObject;
import slimeknights.mantle.registration.object.WoodBlockObject;

public class BlockDeferredRegister
extends DeferredRegisterWrapper<Block> {
    protected final DeferredRegister<Item> itemRegister;

    public BlockDeferredRegister(String modID) {
        super(ForgeRegistries.BLOCKS, modID);
        this.itemRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)modID);
    }

    @Override
    public void register(IEventBus bus) {
        super.register(bus);
        this.itemRegister.register(bus);
    }

    public <B extends Block> RegistryObject<B> registerNoItem(String name, Supplier<? extends B> block) {
        return this.register.register(name, block);
    }

    public RegistryObject<Block> registerNoItem(String name, AbstractBlock.Properties props) {
        return this.registerNoItem(name, () -> new Block(props));
    }

    public <B extends Block> ItemObject<B> register(String name, Supplier<? extends B> block, Function<? super B, ? extends BlockItem> item) {
        RegistryObject blockObj = this.registerNoItem(name, block);
        this.itemRegister.register(name, () -> (BlockItem)item.apply((Object)blockObj.get()));
        return new ItemObject<B>(blockObj);
    }

    public ItemObject<Block> register(String name, AbstractBlock.Properties blockProps, Function<? super Block, ? extends BlockItem> item) {
        return this.register(name, () -> new Block(blockProps), item);
    }

    public BuildingBlockObject registerBuilding(String name, Supplier<? extends Block> block, Function<? super Block, ? extends BlockItem> item) {
        ItemObject<? super Block> blockObj = this.register(name, block, item);
        return new BuildingBlockObject(blockObj, this.register(name + "_slab", () -> new SlabBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)blockObj.get()))), item), this.register(name + "_stairs", () -> new StairsBlock(() -> ((Block)blockObj.get()).func_176223_P(), AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)blockObj.get()))), item));
    }

    public BuildingBlockObject registerBuilding(String name, AbstractBlock.Properties props, Function<? super Block, ? extends BlockItem> item) {
        ItemObject<Block> blockObj = this.register(name, props, item);
        return new BuildingBlockObject(blockObj, this.register(name + "_slab", () -> new SlabBlock(props), item), this.register(name + "_stairs", () -> new StairsBlock(() -> ((Block)blockObj.get()).func_176223_P(), props), item));
    }

    public WallBuildingBlockObject registerWallBuilding(String name, Supplier<? extends Block> block, Function<? super Block, ? extends BlockItem> item) {
        BuildingBlockObject obj = this.registerBuilding(name, block, item);
        return new WallBuildingBlockObject(obj, this.register(name + "_wall", () -> new WallBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)obj.get()))), item));
    }

    public WallBuildingBlockObject registerWallBuilding(String name, AbstractBlock.Properties props, Function<? super Block, ? extends BlockItem> item) {
        return new WallBuildingBlockObject(this.registerBuilding(name, props, item), this.register(name + "_wall", () -> new WallBlock(props), item));
    }

    public FenceBuildingBlockObject registerFenceBuilding(String name, Supplier<? extends Block> block, Function<? super Block, ? extends BlockItem> item) {
        BuildingBlockObject obj = this.registerBuilding(name, block, item);
        return new FenceBuildingBlockObject(obj, this.register(name + "_fence", () -> new FenceBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)obj.get()))), item));
    }

    public FenceBuildingBlockObject registerFenceBuilding(String name, AbstractBlock.Properties props, Function<? super Block, ? extends BlockItem> item) {
        return new FenceBuildingBlockObject(this.registerBuilding(name, props, item), this.register(name + "_fence", () -> new FenceBlock(props), item));
    }

    public WoodBlockObject registerWood(String name, Material planksMaterial, MaterialColor planksColor, SoundType plankSound, ToolType planksTool, Material barkMaterial, MaterialColor barkColor, SoundType barkSound, ItemGroup group) {
        BiFunction<Block, Block, BlockItem> burnableSignItem;
        Function<Block, BlockItem> burnableTallItem;
        Function<Integer, Function> burnableItem;
        WoodType woodType = WoodType.create((String)this.resourceName(name));
        RegistrationHelper.registerWoodType(woodType);
        Item.Properties itemProps = new Item.Properties().func_200916_a(group);
        Item.Properties signProps = new Item.Properties().func_200917_a(16).func_200916_a(group);
        if (barkMaterial.func_76217_h()) {
            burnableItem = burnTime -> block -> new BurnableBlockItem((Block)block, itemProps, (int)burnTime);
            burnableTallItem = block -> new BurnableTallBlockItem((Block)block, itemProps, 200);
            burnableSignItem = (standing, wall) -> new BurnableSignItem(signProps, (Block)standing, (Block)wall, 200);
        } else {
            Function<Block, BlockItem> defaultItemBlock = block -> new BlockItem(block, itemProps);
            burnableItem = burnTime -> defaultItemBlock;
            burnableTallItem = block -> new TallBlockItem(block, itemProps);
            burnableSignItem = (standing, wall) -> new SignItem(signProps, standing, wall);
        }
        Function burnable300 = burnableItem.apply(300);
        AbstractBlock.Properties planksProps = AbstractBlock.Properties.func_200949_a((Material)planksMaterial, (MaterialColor)planksColor).harvestTool(planksTool).func_200948_a(2.0f, 3.0f).func_200947_a(plankSound);
        BuildingBlockObject planks = this.registerBuilding(name + "_planks", planksProps, (? super Block block) -> (BlockItem)((Function)burnableItem.apply(block instanceof SlabBlock ? 150 : 300)).apply(block));
        ItemObject<FenceBlock> fence = this.register(name + "_fence", () -> new FenceBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)planks.get()))), burnable300);
        Supplier<RotatedPillarBlock> stripped = () -> new RotatedPillarBlock(AbstractBlock.Properties.func_200949_a((Material)planksMaterial, (MaterialColor)planksColor).harvestTool(planksTool).func_200943_b(2.0f).func_200947_a(plankSound));
        ItemObject<RotatedPillarBlock> strippedLog = this.register("stripped_" + name + "_log", stripped, burnable300);
        ItemObject<RotatedPillarBlock> strippedWood = this.register("stripped_" + name + "_wood", stripped, burnable300);
        ItemObject<RotatedPillarBlock> log = this.register(name + "_log", () -> new StrippableLogBlock(strippedLog, AbstractBlock.Properties.func_235836_a_((Material)barkMaterial, state -> state.func_177229_b((Property)RotatedPillarBlock.field_176298_M) == Direction.Axis.Y ? planksColor : barkColor).harvestTool(ToolType.AXE).func_200943_b(2.0f).func_200947_a(barkSound)), burnable300);
        ItemObject<RotatedPillarBlock> wood = this.register(name + "_wood", () -> new StrippableLogBlock(strippedWood, AbstractBlock.Properties.func_200949_a((Material)barkMaterial, (MaterialColor)barkColor).harvestTool(ToolType.AXE).func_200943_b(2.0f).func_200947_a(barkSound)), burnable300);
        ItemObject<Block> door = this.register(name + "_door", () -> new WoodenDoorBlock(AbstractBlock.Properties.func_200949_a((Material)planksMaterial, (MaterialColor)planksColor).harvestTool(planksTool).func_200943_b(3.0f).func_200947_a(plankSound).func_226896_b_()), burnableTallItem);
        ItemObject<TrapDoorBlock> trapdoor = this.register(name + "_trapdoor", () -> new TrapDoorBlock(AbstractBlock.Properties.func_200949_a((Material)planksMaterial, (MaterialColor)planksColor).harvestTool(planksTool).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235827_a_(Blocks::func_235427_a_)), burnable300);
        ItemObject<FenceGateBlock> fenceGate = this.register(name + "_fence_gate", () -> new FenceGateBlock(planksProps), burnable300);
        AbstractBlock.Properties redstoneProps = AbstractBlock.Properties.func_200949_a((Material)planksMaterial, (MaterialColor)planksColor).harvestTool(planksTool).func_200942_a().func_200943_b(0.5f).func_200947_a(plankSound);
        ItemObject<PressurePlateBlock> pressurePlate = this.register(name + "_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, redstoneProps), burnable300);
        ItemObject<WoodButtonBlock> button = this.register(name + "_button", () -> new WoodButtonBlock(redstoneProps), burnableItem.apply(100));
        RegistryObject<StandingSignBlock> standingSign = this.registerNoItem(name + "_sign", () -> new StandingSignBlock(AbstractBlock.Properties.func_200949_a((Material)planksMaterial, (MaterialColor)planksColor).func_200942_a().func_200943_b(1.0f).func_200947_a(plankSound), woodType));
        RegistryObject<WallSignBlock> wallSign = this.registerNoItem(name + "_wall_sign", () -> new WallSignBlock(AbstractBlock.Properties.func_200949_a((Material)planksMaterial, (MaterialColor)planksColor).func_200942_a().func_200943_b(1.0f).func_200947_a(plankSound).lootFrom((Supplier)standingSign), woodType));
        RegistrationHelper.registerSignBlock(standingSign);
        RegistrationHelper.registerSignBlock(wallSign);
        this.itemRegister.register(name + "_sign", () -> (BlockItem)burnableSignItem.apply((Block)standingSign.get(), (Block)wallSign.get()));
        return new WoodBlockObject(this.resource(name), woodType, planks, (Supplier<? extends Block>)log, (Supplier<? extends Block>)strippedLog, (Supplier<? extends Block>)wood, (Supplier<? extends Block>)strippedWood, (Supplier<? extends FenceBlock>)fence, (Supplier<? extends FenceGateBlock>)fenceGate, (Supplier<? extends DoorBlock>)door, (Supplier<? extends TrapDoorBlock>)trapdoor, (Supplier<? extends PressurePlateBlock>)pressurePlate, (Supplier<? extends WoodButtonBlock>)button, (Supplier<? extends StandingSignBlock>)standingSign, (Supplier<? extends WallSignBlock>)wallSign);
    }

    public <T extends Enum<T>, B extends Block> EnumObject<T, B> registerEnum(T[] values, String name, Function<T, ? extends B> mapper, Function<? super B, ? extends BlockItem> item) {
        return BlockDeferredRegister.registerEnum(values, (String)name, (T fullName, U value) -> this.register((String)fullName, () -> (Block)mapper.apply(value), item));
    }

    public <T extends Enum<T>, B extends Block> EnumObject<T, B> registerEnum(String name, T[] values, Function<T, ? extends B> mapper, Function<? super B, ? extends BlockItem> item) {
        return BlockDeferredRegister.registerEnum((String)name, values, (T fullName, U value) -> this.register((String)fullName, () -> (Block)mapper.apply(value), item));
    }
}

