/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.event;

import dev.architectury.injectables.annotations.ExpectPlatform;
import me.shedaniel.architectury.event.events.BlockEvent;
import me.shedaniel.architectury.event.events.EntityEvent;
import me.shedaniel.architectury.event.events.PlayerEvent;
import me.shedaniel.architectury.event.forge.EventHandlerImpl;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.architectury.utils.Env;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class EventHandler {
    private static boolean initialized = false;

    private EventHandler() {
    }

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        if (Platform.getEnvironment() == Env.CLIENT) {
            EventHandler.registerClient();
        }
        EventHandler.registerCommon();
        if (Platform.getEnvironment() == Env.SERVER) {
            EventHandler.registerServer();
        }
        EventHandler.registerDelegates();
    }

    @OnlyIn(value=Dist.CLIENT)
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerClient() {
        EventHandlerImpl.registerClient();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerCommon() {
        EventHandlerImpl.registerCommon();
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerServer() {
        EventHandlerImpl.registerServer();
    }

    private static void registerDelegates() {
        BlockEvent.PLACE.register(EntityEvent.PLACE_BLOCK.invoker()::placeBlock);
        BlockEvent.BREAK.register(PlayerEvent.BREAK_BLOCK.invoker()::breakBlock);
    }
}

