/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.event.events;

import me.shedaniel.architectury.event.CompoundEventResult;
import me.shedaniel.architectury.event.Event;
import me.shedaniel.architectury.event.EventFactory;
import me.shedaniel.architectury.utils.IntValue;
import net.minecraft.advancements.Advancement;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface PlayerEvent {
    public static final Event<PlayerJoin> PLAYER_JOIN = EventFactory.createLoop(new PlayerJoin[0]);
    public static final Event<PlayerQuit> PLAYER_QUIT = EventFactory.createLoop(new PlayerQuit[0]);
    public static final Event<PlayerRespawn> PLAYER_RESPAWN = EventFactory.createLoop(new PlayerRespawn[0]);
    public static final Event<PlayerAdvancement> PLAYER_ADVANCEMENT = EventFactory.createLoop(new PlayerAdvancement[0]);
    public static final Event<PlayerClone> PLAYER_CLONE = EventFactory.createLoop(new PlayerClone[0]);
    public static final Event<CraftItem> CRAFT_ITEM = EventFactory.createLoop(new CraftItem[0]);
    public static final Event<SmeltItem> SMELT_ITEM = EventFactory.createLoop(new SmeltItem[0]);
    public static final Event<PickupItemPredicate> PICKUP_ITEM_PRE = EventFactory.createInteractionResult(new PickupItemPredicate[0]);
    public static final Event<PickupItem> PICKUP_ITEM_POST = EventFactory.createLoop(new PickupItem[0]);
    public static final Event<ChangeDimension> CHANGE_DIMENSION = EventFactory.createLoop(new ChangeDimension[0]);
    public static final Event<DropItem> DROP_ITEM = EventFactory.createLoop(new DropItem[0]);
    public static final Event<OpenMenu> OPEN_MENU = EventFactory.createLoop(new OpenMenu[0]);
    public static final Event<CloseMenu> CLOSE_MENU = EventFactory.createLoop(new CloseMenu[0]);
    public static final Event<FillBucket> FILL_BUCKET = EventFactory.createCompoundEventResult(new FillBucket[0]);
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0")
    public static final Event<BreakBlock> BREAK_BLOCK = EventFactory.createInteractionResult(new BreakBlock[0]);

    public static interface FillBucket {
        public CompoundEventResult<ItemStack> fill(PlayerEntity var1, World var2, ItemStack var3, @Nullable RayTraceResult var4);
    }

    public static interface CloseMenu {
        public void close(PlayerEntity var1, Container var2);
    }

    public static interface OpenMenu {
        public void open(PlayerEntity var1, Container var2);
    }

    public static interface BreakBlock {
        public ActionResultType breakBlock(World var1, BlockPos var2, BlockState var3, ServerPlayerEntity var4, @Nullable IntValue var5);
    }

    public static interface DropItem {
        public ActionResultType drop(PlayerEntity var1, ItemEntity var2);
    }

    public static interface ChangeDimension {
        public void change(ServerPlayerEntity var1, RegistryKey<World> var2, RegistryKey<World> var3);
    }

    public static interface PickupItem {
        public void pickup(PlayerEntity var1, ItemEntity var2, ItemStack var3);
    }

    public static interface PickupItemPredicate {
        public ActionResultType canPickup(PlayerEntity var1, ItemEntity var2, ItemStack var3);
    }

    public static interface SmeltItem {
        public void smelt(PlayerEntity var1, ItemStack var2);
    }

    public static interface CraftItem {
        public void craft(PlayerEntity var1, ItemStack var2, IInventory var3);
    }

    public static interface PlayerAdvancement {
        public void award(ServerPlayerEntity var1, Advancement var2);
    }

    public static interface PlayerClone {
        public void clone(ServerPlayerEntity var1, ServerPlayerEntity var2, boolean var3);
    }

    public static interface PlayerRespawn {
        public void respawn(ServerPlayerEntity var1, boolean var2);
    }

    public static interface PlayerQuit {
        public void quit(ServerPlayerEntity var1);
    }

    public static interface PlayerJoin {
        public void join(ServerPlayerEntity var1);
    }
}

