/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.networking;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Collections;
import java.util.List;
import me.shedaniel.architectury.networking.forge.NetworkManagerImpl;
import me.shedaniel.architectury.networking.transformers.PacketCollector;
import me.shedaniel.architectury.networking.transformers.PacketSink;
import me.shedaniel.architectury.networking.transformers.PacketTransformer;
import me.shedaniel.architectury.networking.transformers.SinglePacketCollector;
import me.shedaniel.architectury.utils.Env;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

public final class NetworkManager {
    public static void registerReceiver(Side side, ResourceLocation id, NetworkReceiver receiver) {
        NetworkManager.registerReceiver(side, id, Collections.emptyList(), receiver);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ApiStatus.Experimental
    @ExpectPlatform.Transformed
    public static void registerReceiver(Side side, ResourceLocation id, List<PacketTransformer> packetTransformers, NetworkReceiver receiver) {
        void var3_3;
        void var2_2;
        void var1_1;
        NetworkManagerImpl.registerReceiver(side, (ResourceLocation)var1_1, (List<PacketTransformer>)var2_2, (NetworkReceiver)var3_3);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static IPacket<?> toPacket(Side side, ResourceLocation id, PacketBuffer buf) {
        SinglePacketCollector sink = new SinglePacketCollector(null);
        NetworkManager.collectPackets(sink, side, id, buf);
        return sink.getPacket();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static List<IPacket<?>> toPackets(Side side, ResourceLocation id, PacketBuffer buf) {
        PacketCollector sink = new PacketCollector(null);
        NetworkManager.collectPackets(sink, side, id, buf);
        return sink.collect();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void collectPackets(PacketSink sink, Side side, ResourceLocation id, PacketBuffer buf) {
        void var3_3;
        void var2_2;
        void var1_1;
        NetworkManagerImpl.collectPackets(sink, (Side)var1_1, (ResourceLocation)var2_2, (PacketBuffer)var3_3);
    }

    public static void sendToPlayer(ServerPlayerEntity player, ResourceLocation id, PacketBuffer buf) {
        NetworkManager.collectPackets(PacketSink.ofPlayer(player), NetworkManager.serverToClient(), id, buf);
    }

    public static void sendToPlayers(Iterable<ServerPlayerEntity> players, ResourceLocation id, PacketBuffer buf) {
        NetworkManager.collectPackets(PacketSink.ofPlayers(players), NetworkManager.serverToClient(), id, buf);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendToServer(ResourceLocation id, PacketBuffer buf) {
        NetworkManager.collectPackets(PacketSink.client(), NetworkManager.clientToServer(), id, buf);
    }

    @OnlyIn(value=Dist.CLIENT)
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean canServerReceive(ResourceLocation id) {
        return NetworkManagerImpl.canServerReceive(id);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean canPlayerReceive(ServerPlayerEntity player, ResourceLocation id) {
        void var1_1;
        return NetworkManagerImpl.canPlayerReceive(player, (ResourceLocation)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IPacket<?> createAddEntityPacket(Entity entity) {
        return NetworkManagerImpl.createAddEntityPacket(entity);
    }

    public static Side s2c() {
        return Side.S2C;
    }

    public static Side c2s() {
        return Side.C2S;
    }

    public static Side serverToClient() {
        return Side.S2C;
    }

    public static Side clientToServer() {
        return Side.C2S;
    }

    public static enum Side {
        S2C,
        C2S;

    }

    public static interface PacketContext {
        public PlayerEntity getPlayer();

        public void queue(Runnable var1);

        public Env getEnvironment();

        default public Dist getEnv() {
            return this.getEnvironment().toPlatform();
        }
    }

    @FunctionalInterface
    public static interface NetworkReceiver {
        public void receive(PacketBuffer var1, PacketContext var2);
    }
}

