/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.networking.forge;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import me.shedaniel.architectury.networking.NetworkManager;
import me.shedaniel.architectury.networking.forge.ClientNetworkingManager;
import me.shedaniel.architectury.networking.transformers.PacketSink;
import me.shedaniel.architectury.networking.transformers.PacketTransformer;
import me.shedaniel.architectury.utils.Env;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.event.EventNetworkChannel;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="architectury")
public class NetworkManagerImpl {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation CHANNEL_ID = new ResourceLocation("architectury:network");
    static final ResourceLocation SYNC_IDS = new ResourceLocation("architectury:sync_ids");
    static final EventNetworkChannel CHANNEL = NetworkRegistry.newEventChannel((ResourceLocation)CHANNEL_ID, () -> "1", version -> true, version -> true);
    static final Map<ResourceLocation, NetworkManager.NetworkReceiver> S2C = Maps.newHashMap();
    static final Map<ResourceLocation, NetworkManager.NetworkReceiver> C2S = Maps.newHashMap();
    static final Map<ResourceLocation, PacketTransformer> S2C_TRANSFORMERS = Maps.newHashMap();
    static final Map<ResourceLocation, PacketTransformer> C2S_TRANSFORMERS = Maps.newHashMap();
    static final Set<ResourceLocation> serverReceivables = Sets.newHashSet();
    private static final Multimap<PlayerEntity, ResourceLocation> clientReceivables = Multimaps.newMultimap((Map)Maps.newHashMap(), Sets::newHashSet);

    public static void registerReceiver(NetworkManager.Side side, ResourceLocation id, List<PacketTransformer> packetTransformers, NetworkManager.NetworkReceiver receiver) {
        if (side == NetworkManager.Side.C2S) {
            NetworkManagerImpl.registerC2SReceiver(id, packetTransformers, receiver);
        } else if (side == NetworkManager.Side.S2C) {
            NetworkManagerImpl.registerS2CReceiver(id, packetTransformers, receiver);
        }
    }

    public static IPacket<?> toPacket(NetworkManager.Side side, ResourceLocation id, PacketBuffer buffer) {
        PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
        packetBuffer.func_192572_a(id);
        packetBuffer.writeBytes((ByteBuf)buffer);
        return (side == NetworkManager.Side.C2S ? NetworkDirection.PLAY_TO_SERVER : NetworkDirection.PLAY_TO_CLIENT).buildPacket(Pair.of((Object)packetBuffer, (Object)0), CHANNEL_ID).getThis();
    }

    public static void collectPackets(PacketSink sink, NetworkManager.Side side, ResourceLocation id, PacketBuffer buf) {
        PacketTransformer transformer;
        PacketTransformer packetTransformer = transformer = side == NetworkManager.Side.C2S ? C2S_TRANSFORMERS.get(id) : S2C_TRANSFORMERS.get(id);
        if (transformer != null) {
            transformer.outbound(side, id, buf, (side1, id1, buf1) -> sink.accept(NetworkManagerImpl.toPacket(side1, id1, buf1)));
        } else {
            sink.accept(NetworkManagerImpl.toPacket(side, id, buf));
        }
    }

    static <T extends NetworkEvent> Consumer<T> createPacketHandler(Class<T> clazz, Map<ResourceLocation, PacketTransformer> map) {
        return event -> {
            if (event.getClass() != clazz) {
                return;
            }
            final NetworkEvent.Context context = (NetworkEvent.Context)event.getSource().get();
            if (context.getPacketHandled()) {
                return;
            }
            PacketBuffer buffer = event.getPayload();
            if (buffer == null) {
                return;
            }
            ResourceLocation type = buffer.func_192575_l();
            PacketTransformer transformer = (PacketTransformer)map.get(type);
            if (transformer != null) {
                NetworkManager.Side side = context.getDirection().getReceptionSide() == LogicalSide.CLIENT ? NetworkManager.Side.S2C : NetworkManager.Side.C2S;
                NetworkManager.PacketContext packetContext = new NetworkManager.PacketContext(){

                    @Override
                    public PlayerEntity getPlayer() {
                        return this.getEnvironment() == Env.CLIENT ? this.getClientPlayer() : context.getSender();
                    }

                    @Override
                    public void queue(Runnable runnable) {
                        context.enqueueWork(runnable);
                    }

                    @Override
                    public Env getEnvironment() {
                        return context.getDirection().getReceptionSide() == LogicalSide.CLIENT ? Env.CLIENT : Env.SERVER;
                    }

                    private PlayerEntity getClientPlayer() {
                        return (PlayerEntity)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> ClientNetworkingManager::getClientPlayer);
                    }
                };
                transformer.inbound(side, type, buffer, packetContext, (side1, id1, buf1) -> {
                    NetworkManager.NetworkReceiver networkReceiver;
                    NetworkManager.NetworkReceiver networkReceiver2 = networkReceiver = side == NetworkManager.Side.C2S ? C2S.get(id1) : S2C.get(id1);
                    if (networkReceiver == null) {
                        throw new IllegalArgumentException("Network Receiver not found! " + id1);
                    }
                    networkReceiver.receive(buf1, packetContext);
                });
            } else {
                LOGGER.error("Unknown message ID: " + type);
            }
            context.setPacketHandled(true);
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerS2CReceiver(ResourceLocation id, List<PacketTransformer> packetTransformers, NetworkManager.NetworkReceiver receiver) {
        S2C.put(id, receiver);
        PacketTransformer transformer = PacketTransformer.concat(packetTransformers);
        S2C_TRANSFORMERS.put(id, transformer);
    }

    public static void registerC2SReceiver(ResourceLocation id, List<PacketTransformer> packetTransformers, NetworkManager.NetworkReceiver receiver) {
        C2S.put(id, receiver);
        PacketTransformer transformer = PacketTransformer.concat(packetTransformers);
        C2S_TRANSFORMERS.put(id, transformer);
    }

    public static boolean canServerReceive(ResourceLocation id) {
        return serverReceivables.contains(id);
    }

    public static boolean canPlayerReceive(ServerPlayerEntity player, ResourceLocation id) {
        return clientReceivables.get((Object)player).contains(id);
    }

    public static IPacket<?> createAddEntityPacket(Entity entity) {
        return NetworkHooks.getEntitySpawningPacket((Entity)entity);
    }

    static PacketBuffer sendSyncPacket(Map<ResourceLocation, NetworkManager.NetworkReceiver> map) {
        ArrayList availableIds = Lists.newArrayList(map.keySet());
        PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
        packetBuffer.writeInt(availableIds.size());
        for (ResourceLocation availableId : availableIds) {
            packetBuffer.func_192572_a(availableId);
        }
        return packetBuffer;
    }

    @SubscribeEvent
    public static void loggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        NetworkManager.sendToPlayer((ServerPlayerEntity)event.getPlayer(), SYNC_IDS, NetworkManagerImpl.sendSyncPacket(C2S));
    }

    @SubscribeEvent
    public static void loggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        clientReceivables.removeAll((Object)event.getPlayer());
    }

    static {
        CHANNEL.addListener(NetworkManagerImpl.createPacketHandler(NetworkEvent.ClientCustomPayloadEvent.class, C2S_TRANSFORMERS));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ClientNetworkingManager::initClient);
        NetworkManagerImpl.registerC2SReceiver(SYNC_IDS, Collections.emptyList(), (buffer, context) -> {
            Set receivables = (Set)clientReceivables.get((Object)context.getPlayer());
            int size = buffer.readInt();
            receivables.clear();
            for (int i = 0; i < size; ++i) {
                receivables.add(buffer.func_192575_l());
            }
        });
    }
}

