/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.registry.trade.forge;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.util.NonNullList;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="architectury")
public class TradeRegistryImpl {
    private static final Map<VillagerProfession, Int2ObjectMap<List<VillagerTrades.ITrade>>> TRADES_TO_ADD = new HashMap<VillagerProfession, Int2ObjectMap<List<VillagerTrades.ITrade>>>();
    private static final List<VillagerTrades.ITrade> WANDERER_TRADER_TRADES_GENERIC = new ArrayList<VillagerTrades.ITrade>();
    private static final List<VillagerTrades.ITrade> WANDERER_TRADER_TRADES_RARE = new ArrayList<VillagerTrades.ITrade>();

    public static void registerVillagerTrade0(VillagerProfession profession, int level, VillagerTrades.ITrade ... trades) {
        Int2ObjectMap tradesForProfession = TRADES_TO_ADD.computeIfAbsent(profession, $ -> new Int2ObjectOpenHashMap());
        List tradesForLevel = (List)tradesForProfession.computeIfAbsent(level, $ -> new ArrayList());
        Collections.addAll(tradesForLevel, trades);
    }

    public static void registerTradeForWanderingTrader(boolean rare, VillagerTrades.ITrade ... trades) {
        if (rare) {
            Collections.addAll(WANDERER_TRADER_TRADES_RARE, trades);
        } else {
            Collections.addAll(WANDERER_TRADER_TRADES_GENERIC, trades);
        }
    }

    @SubscribeEvent
    public static void onTradeRegistering(VillagerTradesEvent event) {
        Int2ObjectMap<List<VillagerTrades.ITrade>> trades = TRADES_TO_ADD.get(event.getType());
        if (trades != null) {
            for (Int2ObjectMap.Entry entry : trades.int2ObjectEntrySet()) {
                ((List)event.getTrades().computeIfAbsent(entry.getIntKey(), $ -> NonNullList.func_191196_a())).addAll((Collection)entry.getValue());
            }
        }
    }

    @SubscribeEvent
    public static void onWanderingTradeRegistering(WandererTradesEvent event) {
        if (!WANDERER_TRADER_TRADES_GENERIC.isEmpty()) {
            event.getGenericTrades().addAll(WANDERER_TRADER_TRADES_GENERIC);
        }
        if (!WANDERER_TRADER_TRADES_RARE.isEmpty()) {
            event.getRareTrades().addAll(WANDERER_TRADER_TRADES_RARE);
        }
    }
}

