/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.component.fluid;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.IScreenAddonProvider;
import com.hrznstudio.titanium.component.IComponentHandler;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.sideness.ICapabilityHolder;
import com.hrznstudio.titanium.component.sideness.IFacingComponent;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import com.hrznstudio.titanium.container.addon.IContainerAddonProvider;
import com.hrznstudio.titanium.util.FacingUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MultiTankComponent<T extends IComponentHarness>
implements IScreenAddonProvider,
IContainerAddonProvider,
ICapabilityHolder<MultiTankCapabilityHandler<T>>,
IComponentHandler {
    private final LinkedHashSet<FluidTankComponent<T>> tanks = new LinkedHashSet();
    private final HashMap<FacingUtil.Sideness, LazyOptional<MultiTankCapabilityHandler<T>>> lazyOptionals = new HashMap();

    public MultiTankComponent() {
        this.lazyOptionals.put(null, LazyOptional.empty());
        for (FacingUtil.Sideness value : FacingUtil.Sideness.values()) {
            this.lazyOptionals.put(value, LazyOptional.empty());
        }
    }

    @Override
    public void add(Object ... component) {
        Arrays.stream(component).filter(this::accepts).forEach(tank -> {
            this.tanks.add((FluidTankComponent)tank);
            this.rebuildCapability(new FacingUtil.Sideness[]{null});
            this.rebuildCapability(FacingUtil.Sideness.values());
        });
    }

    private boolean accepts(Object component) {
        return component instanceof FluidTankComponent;
    }

    private void rebuildCapability(FacingUtil.Sideness[] sides) {
        for (FacingUtil.Sideness side : sides) {
            this.lazyOptionals.get((Object)side).invalidate();
            this.lazyOptionals.put(side, LazyOptional.of(() -> new MultiTankCapabilityHandler<T>(this.getHandlersForSide(side))));
        }
    }

    private List<FluidTankComponent<T>> getHandlersForSide(FacingUtil.Sideness sideness) {
        if (sideness == null) {
            return new ArrayList<FluidTankComponent<T>>(this.tanks);
        }
        ArrayList<FluidTankComponent<T>> handlers = new ArrayList<FluidTankComponent<T>>();
        for (FluidTankComponent fluidTankComponent : this.tanks) {
            if (fluidTankComponent instanceof IFacingComponent) {
                if (!((IFacingComponent)((Object)fluidTankComponent)).getFacingModes().containsKey((Object)sideness) || !((IFacingComponent)((Object)fluidTankComponent)).getFacingModes().get((Object)sideness).allowsConnection()) continue;
                handlers.add(fluidTankComponent);
                continue;
            }
            handlers.add(fluidTankComponent);
        }
        return handlers;
    }

    @Override
    @Nonnull
    public LazyOptional<MultiTankCapabilityHandler<T>> getCapabilityForSide(@Nullable FacingUtil.Sideness sideness) {
        return this.lazyOptionals.get((Object)sideness);
    }

    @Override
    public boolean handleFacingChange(String handlerName, FacingUtil.Sideness facing, int mode) {
        for (FluidTankComponent fluidTankComponent : this.tanks) {
            if (!fluidTankComponent.getName().equals(handlerName) || !(fluidTankComponent instanceof IFacingComponent)) continue;
            ((IFacingComponent)((Object)fluidTankComponent)).getFacingModes().put(facing, ((IFacingComponent)((Object)fluidTankComponent)).getValidFacingModes()[mode]);
            this.rebuildCapability(new FacingUtil.Sideness[]{facing});
            return true;
        }
        return false;
    }

    @Override
    public Collection<LazyOptional<MultiTankCapabilityHandler<T>>> getLazyOptionals() {
        return this.lazyOptionals.values();
    }

    public HashSet<FluidTankComponent<T>> getTanks() {
        return this.tanks;
    }

    @Override
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        ArrayList<IFactory<? extends IScreenAddon>> addons = new ArrayList<IFactory<? extends IScreenAddon>>();
        for (FluidTankComponent fluidTankComponent : this.tanks) {
            addons.addAll(fluidTankComponent.getScreenAddons());
        }
        return addons;
    }

    @Override
    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        ArrayList<IFactory<? extends IContainerAddon>> addons = new ArrayList<IFactory<? extends IContainerAddon>>();
        for (FluidTankComponent fluidTankComponent : this.tanks) {
            addons.addAll(fluidTankComponent.getContainerAddons());
        }
        return addons;
    }

    public static class MultiTankCapabilityHandler<T extends IComponentHarness>
    implements IFluidHandler {
        private final List<FluidTankComponent<T>> tanks;

        public MultiTankCapabilityHandler(List<FluidTankComponent<T>> tanks) {
            this.tanks = tanks;
        }

        public boolean isEmpty() {
            return this.tanks.isEmpty();
        }

        public int getTanks() {
            return this.tanks.size();
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.tanks.get(tank).getFluid();
        }

        public int getTankCapacity(int tank) {
            return this.tanks.get(tank).getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.tanks.get(tank).isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            for (FluidTankComponent<T> tank : this.tanks) {
                if (tank.fill(resource, IFluidHandler.FluidAction.SIMULATE) == 0) continue;
                return tank.fill(resource, action);
            }
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            for (FluidTankComponent<T> tank : this.tanks) {
                if (tank.drain(resource, IFluidHandler.FluidAction.SIMULATE).isEmpty()) continue;
                return tank.drain(resource, action);
            }
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            for (FluidTankComponent<T> tank : this.tanks) {
                if (tank.drain(maxDrain, IFluidHandler.FluidAction.SIMULATE).isEmpty()) continue;
                return tank.drain(maxDrain, action);
            }
            return FluidStack.EMPTY;
        }
    }
}

