/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.filter;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.filter.FilterAction;
import com.hrznstudio.titanium.api.filter.FilterSlot;
import com.hrznstudio.titanium.api.filter.IFilter;
import com.hrznstudio.titanium.client.screen.addon.ItemstackFilterScreenAddon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class ItemStackFilter
implements IFilter<ItemStack> {
    private static FilterAction<ItemStack> SIMPLE = new FilterAction<ItemStack>((itemStackIFilter, stack) -> Arrays.stream(itemStackIFilter.getFilterSlots()).anyMatch(itemStackFilterSlot -> stack.func_77969_a((ItemStack)itemStackFilterSlot.getFilter())));
    private static FilterAction<ItemStack> IGNORE_DURABILITY = new FilterAction<ItemStack>((itemStackIFilter, stack) -> Arrays.stream(itemStackIFilter.getFilterSlots()).anyMatch(itemStackFilterSlot -> stack.func_185136_b((ItemStack)itemStackFilterSlot.getFilter())));
    private static FilterAction<ItemStack> DURABILITY_LESS_50 = new FilterAction<ItemStack>((itemStackIFilter, stack) -> Arrays.stream(itemStackIFilter.getFilterSlots()).anyMatch(itemStackFilterSlot -> stack.func_77969_a((ItemStack)itemStackFilterSlot.getFilter())) && stack.func_77952_i() < stack.func_77958_k() / 50);
    private static FilterAction<ItemStack> DAMAGED = new FilterAction<ItemStack>((itemStackIFilter, stack) -> Arrays.stream(itemStackIFilter.getFilterSlots()).anyMatch(itemStackFilterSlot -> stack.func_77969_a((ItemStack)itemStackFilterSlot.getFilter())) && stack.func_77952_i() < stack.func_77958_k());
    private static FilterAction<ItemStack> NOT_DAMAGED = new FilterAction<ItemStack>((itemStackIFilter, stack) -> Arrays.stream(itemStackIFilter.getFilterSlots()).anyMatch(itemStackFilterSlot -> stack.func_77969_a((ItemStack)itemStackFilterSlot.getFilter())) && stack.func_77952_i() == stack.func_77958_k());
    private static FilterAction<ItemStack> DURABILITY_MORE_50 = new FilterAction<ItemStack>((itemStackIFilter, stack) -> Arrays.stream(itemStackIFilter.getFilterSlots()).anyMatch(itemStackFilterSlot -> stack.func_77969_a((ItemStack)itemStackFilterSlot.getFilter())) && stack.func_77952_i() > stack.func_77958_k() / 50);
    private static FilterAction<ItemStack>[] ACTIONS = new FilterAction[]{SIMPLE, IGNORE_DURABILITY, DURABILITY_LESS_50, DAMAGED, NOT_DAMAGED, DURABILITY_MORE_50};
    private final FilterSlot<ItemStack>[] filter;
    private IFilter.Type type;
    private int pointer;
    private String name;

    public ItemStackFilter(String name, int filterSize) {
        this.name = name;
        this.filter = new FilterSlot[filterSize];
        this.type = IFilter.Type.WHITELIST;
        this.pointer = 0;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean acceptsAsFilter(ItemStack filter) {
        return true;
    }

    @Override
    public void setFilter(int slot, ItemStack stack) {
        if (slot < 0 || slot >= this.filter.length) {
            throw new RuntimeException("Filter slot " + slot + " not in valid range - [0," + this.filter.length + ")");
        }
        this.filter[slot].setFilter(stack);
        this.onContentChanged();
    }

    @Override
    public void setFilter(int slot, FilterSlot<ItemStack> filterSlot) {
        if (slot < 0 || slot >= this.filter.length) {
            throw new RuntimeException("Filter slot " + slot + " not in valid range - [0," + this.filter.length + ")");
        }
        this.filter[slot] = filterSlot;
    }

    @Override
    public FilterSlot<ItemStack>[] getFilterSlots() {
        return this.filter;
    }

    @Override
    public IFilter.Type getType() {
        return this.type;
    }

    @Override
    public void toggleFilterMode() {
        this.type = this.type.equals((Object)IFilter.Type.WHITELIST) ? IFilter.Type.BLACKLIST : IFilter.Type.WHITELIST;
    }

    @Override
    public void selectNextFilter() {
        this.pointer = (this.pointer + 1) % ACTIONS.length;
    }

    @Override
    public FilterAction<ItemStack> getAction() {
        return ACTIONS[this.pointer];
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74768_a("Pointer", this.pointer);
        CompoundNBT filter = new CompoundNBT();
        for (FilterSlot<ItemStack> itemStackFilterSlot : this.filter) {
            if (itemStackFilterSlot == null || itemStackFilterSlot.getFilter().func_190926_b()) continue;
            filter.func_218657_a(itemStackFilterSlot.getFilterID() + "", (INBT)itemStackFilterSlot.getFilter().serializeNBT());
        }
        compoundNBT.func_218657_a("Filter", (INBT)filter);
        compoundNBT.func_74778_a("Type", this.type.name());
        return compoundNBT;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.pointer = nbt.func_74762_e("Pointer");
        CompoundNBT filter = nbt.func_74775_l("Filter");
        for (FilterSlot<ItemStack> filterSlot : this.filter) {
            filterSlot.setFilter(ItemStack.field_190927_a);
        }
        for (String key : filter.func_150296_c()) {
            this.filter[Integer.parseInt(key)].setFilter(ItemStack.func_199557_a((CompoundNBT)filter.func_74775_l(key)));
        }
        this.type = IFilter.Type.valueOf(nbt.func_74779_i("Type"));
    }

    @Override
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        ArrayList<IFactory<? extends IScreenAddon>> list = new ArrayList<IFactory<? extends IScreenAddon>>();
        list.add(() -> new ItemstackFilterScreenAddon(this));
        return list;
    }

    public void onContentChanged() {
    }
}

