/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client;

import com.mrcrayfish.guns.common.CustomGun;
import com.mrcrayfish.guns.common.NetworkGunManager;
import com.mrcrayfish.guns.init.ModItems;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cgm", value={Dist.CLIENT})
public class CustomGunManager {
    private static Map<ResourceLocation, CustomGun> customGunMap;

    public static boolean updateCustomGuns(NetworkGunManager.IGunProvider provider) {
        customGunMap = provider.getCustomGuns();
        return true;
    }

    public static void fill(NonNullList<ItemStack> items) {
        if (customGunMap != null) {
            customGunMap.forEach((id, gun) -> {
                ItemStack stack = new ItemStack((IItemProvider)ModItems.PISTOL.get());
                stack.func_200302_a((ITextComponent)new TranslationTextComponent("item." + id.func_110624_b() + "." + id.func_110623_a() + ".name"));
                CompoundNBT tag = stack.func_196082_o();
                tag.func_218657_a("Model", (INBT)gun.getModel().func_77955_b(new CompoundNBT()));
                tag.func_218657_a("Gun", (INBT)gun.getGun().serializeNBT());
                tag.func_74757_a("Custom", true);
                tag.func_74768_a("AmmoCount", gun.getGun().getGeneral().getMaxAmmo());
                items.add((Object)stack);
            });
        }
    }

    @SubscribeEvent
    public static void onClientDisconnect(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        customGunMap = null;
    }
}

