/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client.particle;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mrcrayfish.guns.Config;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BulletHoleParticle
extends SpriteTexturedParticle {
    private final Direction direction;
    private final BlockPos pos;
    private int uOffset;
    private int vOffset;
    private float textureDensity;

    public BulletHoleParticle(ClientWorld world, double x, double y, double z, Direction direction, BlockPos pos) {
        super(world, x, y, z);
        this.func_217567_a(this.getSprite(pos));
        this.direction = direction;
        this.pos = pos;
        this.field_70547_e = (int)((float)((Integer)Config.CLIENT.particle.bulletHoleLifeMin.get()).intValue() + world.field_73012_v.nextFloat() * (float)((Integer)Config.CLIENT.particle.bulletHoleLifeMax.get() - (Integer)Config.CLIENT.particle.bulletHoleLifeMin.get()));
        this.field_190017_n = false;
        this.field_70545_g = 0.0f;
        this.field_70544_f = 0.05f;
        BlockState state = world.func_180495_p(pos);
        if (world.func_180495_p(pos).isAir((IBlockReader)world, pos)) {
            this.func_187112_i();
        }
        int color = this.getBlockColor(state, (World)world, pos, direction);
        this.field_70552_h = (float)(color >> 16 & 0xFF) / 255.0f / 3.0f;
        this.field_70553_i = (float)(color >> 8 & 0xFF) / 255.0f / 3.0f;
        this.field_70551_j = (float)(color & 0xFF) / 255.0f / 3.0f;
        this.field_82339_as = 0.9f;
    }

    private int getBlockColor(BlockState state, World world, BlockPos pos, Direction direction) {
        if (state.func_177230_c() == Blocks.field_196658_i) {
            return Integer.MAX_VALUE;
        }
        return Minecraft.func_71410_x().func_184125_al().func_228054_a_(state, (IBlockDisplayReader)world, pos, 0);
    }

    protected void func_217567_a(TextureAtlasSprite sprite) {
        super.func_217567_a(sprite);
        this.uOffset = this.field_187136_p.nextInt(16);
        this.vOffset = this.field_187136_p.nextInt(16);
        this.textureDensity = (sprite.func_94212_f() - sprite.func_94209_e()) / 16.0f;
    }

    private TextureAtlasSprite getSprite(BlockPos pos) {
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientWorld world = minecraft.field_71441_e;
        if (world != null) {
            BlockState state = world.func_180495_p(pos);
            return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
        }
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(MissingTextureSprite.func_195675_b());
    }

    protected float func_217563_c() {
        return this.field_217569_E.func_94209_e() + (float)this.uOffset * this.textureDensity;
    }

    protected float func_217562_e() {
        return this.field_217569_E.func_94206_g() + (float)this.vOffset * this.textureDensity;
    }

    protected float func_217564_d() {
        return this.func_217563_c() + this.textureDensity;
    }

    protected float func_217560_f() {
        return this.func_217562_e() + this.textureDensity;
    }

    public void func_189213_a() {
        super.func_189213_a();
        if (this.field_187122_b.func_180495_p(this.pos).isAir((IBlockReader)this.field_187122_b, this.pos)) {
            this.func_187112_i();
        }
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        Vector3d view = renderInfo.func_216785_c();
        float particleX = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187123_c, (double)this.field_187126_f) - view.func_82615_a());
        float particleY = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187124_d, (double)this.field_187127_g) - view.func_82617_b());
        float particleZ = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187125_e, (double)this.field_187128_h) - view.func_82616_c());
        Quaternion quaternion = this.direction.func_229384_a_();
        Vector3f[] points = new Vector3f[]{new Vector3f(-1.0f, 0.0f, -1.0f), new Vector3f(-1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, -1.0f)};
        float scale = this.func_217561_b(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = points[i];
            vector3f.func_214905_a(quaternion);
            vector3f.func_195898_a(scale);
            vector3f.func_195904_b(particleX, particleY, particleZ);
        }
        float f7 = this.func_217563_c();
        float f8 = this.func_217564_d();
        float f5 = this.func_217562_e();
        float f6 = this.func_217560_f();
        int j = this.func_189214_a(partialTicks);
        float fade = (Double)Config.CLIENT.particle.bulletHoleFadeThreshold.get() >= 1.0 ? 1.0f : 1.0f - Math.max((float)this.field_70546_d - (float)this.field_70547_e * ((Double)Config.CLIENT.particle.bulletHoleFadeThreshold.get()).floatValue(), 0.0f) / ((float)this.field_70547_e - (float)this.field_70547_e * ((Double)Config.CLIENT.particle.bulletHoleFadeThreshold.get()).floatValue());
        buffer.func_225582_a_((double)points[0].func_195899_a(), (double)points[0].func_195900_b(), (double)points[0].func_195902_c()).func_225583_a_(f8, f6).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as * fade).func_227886_a_(j).func_181675_d();
        buffer.func_225582_a_((double)points[1].func_195899_a(), (double)points[1].func_195900_b(), (double)points[1].func_195902_c()).func_225583_a_(f8, f5).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as * fade).func_227886_a_(j).func_181675_d();
        buffer.func_225582_a_((double)points[2].func_195899_a(), (double)points[2].func_195900_b(), (double)points[2].func_195902_c()).func_225583_a_(f7, f5).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as * fade).func_227886_a_(j).func_181675_d();
        buffer.func_225582_a_((double)points[3].func_195899_a(), (double)points[3].func_195900_b(), (double)points[3].func_195902_c()).func_225583_a_(f7, f6).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as * fade).func_227886_a_(j).func_181675_d();
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217601_a;
    }
}

