/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.common;

import com.google.common.collect.Maps;
import com.mrcrayfish.guns.common.Gun;
import com.mrcrayfish.guns.item.GunItem;
import com.mrcrayfish.guns.util.GunEnchantmentHelper;
import com.mrcrayfish.guns.util.GunModifierHelper;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Util;
import org.apache.commons.lang3.tuple.Pair;

public class ShootTracker {
    private static final Map<PlayerEntity, ShootTracker> SHOOT_TRACKER_MAP = new WeakHashMap<PlayerEntity, ShootTracker>();
    private final Map<Item, Pair<Long, Integer>> cooldownMap = Maps.newHashMap();

    public static ShootTracker getShootTracker(PlayerEntity player) {
        return SHOOT_TRACKER_MAP.computeIfAbsent(player, player1 -> new ShootTracker());
    }

    public void putCooldown(ItemStack weapon, GunItem item, Gun modifiedGun) {
        int rate = GunEnchantmentHelper.getRate(weapon, modifiedGun);
        rate = GunModifierHelper.getModifiedRate(weapon, rate);
        this.cooldownMap.put(item, (Pair<Long, Integer>)Pair.of((Object)Util.func_211177_b(), (Object)(rate * 50)));
    }

    public boolean hasCooldown(GunItem item) {
        Pair<Long, Integer> pair = this.cooldownMap.get(item);
        if (pair != null) {
            return Util.func_211177_b() - (Long)pair.getLeft() < (long)((Integer)pair.getRight() - 50);
        }
        return false;
    }

    public long getRemaining(GunItem item) {
        Pair<Long, Integer> pair = this.cooldownMap.get(item);
        if (pair != null) {
            return (long)((Integer)pair.getRight()).intValue() - (Util.func_211177_b() - (Long)pair.getLeft());
        }
        return 0L;
    }
}

