/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.entity;

import com.mrcrayfish.guns.Config;
import com.mrcrayfish.guns.entity.ThrowableGrenadeEntity;
import com.mrcrayfish.guns.entity.ThrowableItemEntity;
import com.mrcrayfish.guns.init.ModEffects;
import com.mrcrayfish.guns.init.ModEntities;
import com.mrcrayfish.guns.init.ModItems;
import com.mrcrayfish.guns.init.ModSounds;
import com.mrcrayfish.guns.network.PacketHandler;
import com.mrcrayfish.guns.network.message.MessageStunGrenade;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber
public class ThrowableStunGrenadeEntity
extends ThrowableGrenadeEntity {
    public ThrowableStunGrenadeEntity(EntityType<? extends ThrowableGrenadeEntity> entityType, World world) {
        super(entityType, world);
    }

    public ThrowableStunGrenadeEntity(EntityType<? extends ThrowableGrenadeEntity> entityType, World world, LivingEntity player) {
        super(entityType, world, player);
        this.setItem(new ItemStack((IItemProvider)ModItems.STUN_GRENADE.get()));
    }

    public ThrowableStunGrenadeEntity(World world, LivingEntity player, int maxCookTime) {
        super((EntityType<? extends ThrowableItemEntity>)((EntityType)ModEntities.THROWABLE_STUN_GRENADE.get()), world, player);
        this.setItem(new ItemStack((IItemProvider)ModItems.STUN_GRENADE.get()));
        this.setMaxLife(maxCookTime);
    }

    @SubscribeEvent
    public static void blindMobs(LivingSetAttackTargetEvent event) {
        if (((Boolean)Config.COMMON.stunGrenades.blind.blindMobs.get()).booleanValue() && event.getTarget() != null && event.getEntityLiving() instanceof MobEntity && event.getEntityLiving().func_70644_a((Effect)ModEffects.BLINDED.get())) {
            ((MobEntity)event.getEntityLiving()).func_70624_b(null);
        }
    }

    @Override
    public void onDeath() {
        double y = this.func_226278_cu_() + (double)this.func_200600_R().func_220334_j().field_220316_b * 0.5;
        this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), y, this.func_226281_cx_(), (SoundEvent)ModSounds.ENTITY_STUN_GRENADE_EXPLOSION.get(), SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        PacketHandler.getPlayChannel().send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.func_226277_ct_(), y, this.func_226281_cx_(), 64.0, this.field_70170_p.func_234923_W_())), (Object)new MessageStunGrenade(this.func_226277_ct_(), y, this.func_226281_cx_()));
        double diameter = Math.max((Double)Config.COMMON.stunGrenades.deafen.criteria.radius.get(), (Double)Config.COMMON.stunGrenades.blind.criteria.radius.get()) * 2.0 + 1.0;
        int minX = MathHelper.func_76128_c((double)(this.func_226277_ct_() - diameter));
        int maxX = MathHelper.func_76128_c((double)(this.func_226277_ct_() + diameter));
        int minY = MathHelper.func_76128_c((double)(y - diameter));
        int maxY = MathHelper.func_76128_c((double)(y + diameter));
        int minZ = MathHelper.func_76128_c((double)(this.func_226281_cx_() - diameter));
        int maxZ = MathHelper.func_76128_c((double)(this.func_226281_cx_() + diameter));
        Vector3d grenade = new Vector3d(this.func_226277_ct_(), y, this.func_226281_cx_());
        for (LivingEntity entity : this.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ))) {
            if (entity.func_180427_aV()) continue;
            Vector3d eyes = entity.func_174824_e(1.0f);
            Vector3d directionGrenade = grenade.func_178788_d(eyes);
            double distance = directionGrenade.func_72433_c();
            double angle = Math.toDegrees(Math.acos(entity.func_70676_i(1.0f).func_72430_b(directionGrenade.func_72432_b())));
            if (this.calculateAndApplyEffect((Effect)ModEffects.DEAFENED.get(), Config.COMMON.stunGrenades.deafen.criteria, entity, grenade, eyes, distance, angle) && ((Boolean)Config.COMMON.stunGrenades.deafen.panicMobs.get()).booleanValue()) {
                entity.func_70604_c(entity);
            }
            if (!this.calculateAndApplyEffect((Effect)ModEffects.BLINDED.get(), Config.COMMON.stunGrenades.blind.criteria, entity, grenade, eyes, distance, angle) || !((Boolean)Config.COMMON.stunGrenades.blind.blindMobs.get()).booleanValue() || !(entity instanceof MobEntity)) continue;
            ((MobEntity)entity).func_70624_b(null);
        }
    }

    private boolean calculateAndApplyEffect(Effect effect, Config.EffectCriteria criteria, LivingEntity entity, Vector3d grenade, Vector3d eyes, double distance, double angle) {
        double angleMax = (Double)criteria.angleEffect.get() * 0.5;
        if (distance <= (Double)criteria.radius.get() && angleMax > 0.0 && angle <= angleMax && (effect != ModEffects.BLINDED.get() || !((Boolean)Config.COMMON.stunGrenades.blind.criteria.raytraceOpaqueBlocks.get()).booleanValue() || this.rayTraceOpaqueBlocks(this.field_70170_p, eyes, grenade, false, false, false) == null)) {
            int durationBlinded = (int)Math.round((double)((Integer)criteria.durationMax.get()).intValue() - (double)((Integer)criteria.durationMax.get() - (Integer)criteria.durationMin.get()) * (distance / (Double)criteria.radius.get()));
            durationBlinded = (int)((double)durationBlinded * (1.0 - angle * (1.0 - (Double)criteria.angleAttenuationMax.get()) / angleMax));
            entity.func_195064_c(new EffectInstance(effect, durationBlinded, 0, false, false));
            return !(entity instanceof PlayerEntity);
        }
        return false;
    }

    @Nullable
    public RayTraceResult rayTraceOpaqueBlocks(World world, Vector3d start, Vector3d end, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        if (!(Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c))) {
            if (!(Double.isNaN(end.field_72450_a) || Double.isNaN(end.field_72448_b) || Double.isNaN(end.field_72449_c))) {
                BlockRayTraceResult raytraceresult;
                int startZ;
                int startY;
                int endX = MathHelper.func_76128_c((double)end.field_72450_a);
                int endY = MathHelper.func_76128_c((double)end.field_72448_b);
                int endZ = MathHelper.func_76128_c((double)end.field_72449_c);
                int startX = MathHelper.func_76128_c((double)start.field_72450_a);
                BlockPos pos = new BlockPos(startX, startY = MathHelper.func_76128_c((double)start.field_72448_b), startZ = MathHelper.func_76128_c((double)start.field_72449_c));
                BlockState stateInside = world.func_180495_p(pos);
                if (!(stateInside.func_200016_a((IBlockReader)world, pos) == 0 || ignoreBlockWithoutBoundingBox && stateInside.func_196952_d((IBlockReader)world, pos) == VoxelShapes.func_197880_a() || (raytraceresult = world.func_217299_a(new RayTraceContext(start, end, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this))) == null)) {
                    return raytraceresult;
                }
                RayTraceResult raytraceresult2 = null;
                int limit = 200;
                while (limit-- >= 0) {
                    BlockState state;
                    Direction direction;
                    if (Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c)) {
                        return null;
                    }
                    if (startX == endX && startY == endY && startZ == endZ) {
                        return returnLastUncollidableBlock ? raytraceresult2 : null;
                    }
                    boolean completedX = true;
                    boolean completedY = true;
                    boolean completedZ = true;
                    double d0 = 999.0;
                    double d1 = 999.0;
                    double d2 = 999.0;
                    if (endX > startX) {
                        d0 = startX + 1;
                    } else if (endX < startX) {
                        d0 = startX;
                    } else {
                        completedX = false;
                    }
                    if (endY > startY) {
                        d1 = startY + 1;
                    } else if (endY < startY) {
                        d1 = startY;
                    } else {
                        completedY = false;
                    }
                    if (endZ > startZ) {
                        d2 = startZ + 1;
                    } else if (endZ < startZ) {
                        d2 = startZ;
                    } else {
                        completedZ = false;
                    }
                    double d3 = 999.0;
                    double d4 = 999.0;
                    double d5 = 999.0;
                    double d6 = end.field_72450_a - start.field_72450_a;
                    double d7 = end.field_72448_b - start.field_72448_b;
                    double d8 = end.field_72449_c - start.field_72449_c;
                    if (completedX) {
                        d3 = (d0 - start.field_72450_a) / d6;
                    }
                    if (completedY) {
                        d4 = (d1 - start.field_72448_b) / d7;
                    }
                    if (completedZ) {
                        d5 = (d2 - start.field_72449_c) / d8;
                    }
                    if (d3 == 0.0) {
                        d3 = -1.0E-4;
                    }
                    if (d4 == 0.0) {
                        d4 = -1.0E-4;
                    }
                    if (d5 == 0.0) {
                        d5 = -1.0E-4;
                    }
                    if (d3 < d4 && d3 < d5) {
                        direction = endX > startX ? Direction.WEST : Direction.EAST;
                        start = new Vector3d(d0, start.field_72448_b + d7 * d3, start.field_72449_c + d8 * d3);
                    } else if (d4 < d5) {
                        direction = endY > startY ? Direction.DOWN : Direction.UP;
                        start = new Vector3d(start.field_72450_a + d6 * d4, d1, start.field_72449_c + d8 * d4);
                    } else {
                        direction = endZ > startZ ? Direction.NORTH : Direction.SOUTH;
                        start = new Vector3d(start.field_72450_a + d6 * d5, start.field_72448_b + d7 * d5, d2);
                    }
                    if ((state = world.func_180495_p(pos = new BlockPos(startX = MathHelper.func_76128_c((double)start.field_72450_a) - (direction == Direction.EAST ? 1 : 0), startY = MathHelper.func_76128_c((double)start.field_72448_b) - (direction == Direction.UP ? 1 : 0), startZ = MathHelper.func_76128_c((double)start.field_72449_c) - (direction == Direction.SOUTH ? 1 : 0)))).func_200016_a((IBlockReader)world, pos) == 0 || ignoreBlockWithoutBoundingBox && state.func_185904_a() != Material.field_151567_E && state.func_196952_d((IBlockReader)world, pos) == VoxelShapes.func_197880_a()) continue;
                    return world.func_217299_a(new RayTraceContext(start, end, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
                }
                return returnLastUncollidableBlock ? raytraceresult2 : null;
            }
            return null;
        }
        return null;
    }
}

