/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.util;

import com.mrcrayfish.guns.common.Gun;
import com.mrcrayfish.guns.interfaces.IGunModifier;
import com.mrcrayfish.guns.item.attachment.IAttachment;
import com.mrcrayfish.guns.item.attachment.impl.Attachment;
import com.mrcrayfish.guns.util.GunEnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public class GunModifierHelper {
    private static final IGunModifier[] EMPTY = new IGunModifier[0];

    private static IGunModifier[] getModifiers(ItemStack weapon, IAttachment.Type type) {
        ItemStack stack = Gun.getAttachment(type, weapon);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IAttachment) {
            IAttachment attachment = (IAttachment)stack.func_77973_b();
            return ((Attachment)attachment.getProperties()).getModifiers();
        }
        return EMPTY;
    }

    public static int getModifiedProjectileLife(ItemStack weapon, int life) {
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                life = modifier.modifyProjectileLife(life);
            }
        }
        return life;
    }

    public static double getModifiedProjectileGravity(ItemStack weapon, double gravity) {
        IGunModifier[] modifiers;
        int i;
        for (i = 0; i < IAttachment.Type.values().length; ++i) {
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                gravity = modifier.modifyProjectileGravity(gravity);
            }
        }
        for (i = 0; i < IAttachment.Type.values().length; ++i) {
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                gravity += modifier.additionalProjectileGravity();
            }
        }
        return gravity;
    }

    public static float getModifiedSpread(ItemStack weapon, float spread) {
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                spread = modifier.modifyProjectileSpread(spread);
            }
        }
        return spread;
    }

    public static double getModifiedProjectileSpeed(ItemStack weapon, double speed) {
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                speed = modifier.modifyProjectileSpeed(speed);
            }
        }
        return speed;
    }

    public static float getFireSoundVolume(ItemStack weapon) {
        float volume = 1.0f;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                volume = modifier.modifyFireSoundVolume(volume);
            }
        }
        return MathHelper.func_76131_a((float)volume, (float)0.0f, (float)16.0f);
    }

    public static double getMuzzleFlashSize(ItemStack weapon, double size) {
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                size = modifier.modifyMuzzleFlashSize(size);
            }
        }
        return size;
    }

    public static float getKickReduction(ItemStack weapon) {
        float kickReduction = 1.0f;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                kickReduction *= MathHelper.func_76131_a((float)modifier.kickModifier(), (float)0.0f, (float)1.0f);
            }
        }
        return 1.0f - kickReduction;
    }

    public static float getRecoilModifier(ItemStack weapon) {
        float recoilReduction = 1.0f;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                recoilReduction *= MathHelper.func_76131_a((float)modifier.recoilModifier(), (float)0.0f, (float)1.0f);
            }
        }
        return 1.0f - recoilReduction;
    }

    public static boolean isSilencedFire(ItemStack weapon) {
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                if (!modifier.silencedFire()) continue;
                return true;
            }
        }
        return false;
    }

    public static double getModifiedFireSoundRadius(ItemStack weapon, double radius) {
        double minRadius = radius;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                double newRadius = modifier.modifyFireSoundRadius(radius);
                if (!(newRadius < minRadius)) continue;
                minRadius = newRadius;
            }
        }
        return MathHelper.func_151237_a((double)minRadius, (double)0.0, (double)Double.MAX_VALUE);
    }

    public static float getAdditionalDamage(ItemStack weapon) {
        float additionalDamage = 0.0f;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                additionalDamage += modifier.additionalDamage();
            }
        }
        return additionalDamage;
    }

    public static float getModifiedProjectileDamage(ItemStack weapon, float damage) {
        float finalDamage = damage;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                finalDamage = modifier.modifyProjectileDamage(finalDamage);
            }
        }
        return finalDamage;
    }

    public static float getModifiedDamage(ItemStack weapon, Gun modifiedGun, float damage) {
        IGunModifier[] modifiers;
        int i;
        float finalDamage = damage;
        for (i = 0; i < IAttachment.Type.values().length; ++i) {
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                finalDamage = modifier.modifyProjectileDamage(finalDamage);
            }
        }
        for (i = 0; i < IAttachment.Type.values().length; ++i) {
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                finalDamage += modifier.additionalDamage();
            }
        }
        return finalDamage;
    }

    public static double getModifiedAimDownSightSpeed(ItemStack weapon, double speed) {
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                speed = modifier.modifyAimDownSightSpeed(speed);
            }
        }
        return MathHelper.func_151237_a((double)speed, (double)0.01, (double)Double.MAX_VALUE);
    }

    public static int getModifiedRate(ItemStack weapon, int rate) {
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                rate = modifier.modifyFireRate(rate);
            }
        }
        return MathHelper.func_76125_a((int)rate, (int)0, (int)Integer.MAX_VALUE);
    }

    public static float getCriticalChance(ItemStack weapon) {
        float chance = 0.0f;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                chance += modifier.criticalChance();
            }
        }
        return MathHelper.func_76131_a((float)(chance += GunEnchantmentHelper.getPuncturingChance(weapon)), (float)0.0f, (float)1.0f);
    }
}

