/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurabletypeaction;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.cyclops.cyclopscore.client.model.IDynamicModelElement;
import org.cyclops.cyclopscore.config.configurabletypeaction.ConfigurableTypeActionForge;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

public class ItemAction
extends ConfigurableTypeActionForge<ItemConfig, Item> {
    private static final List<ItemConfig> MODEL_ENTRIES = Lists.newArrayList();

    @Override
    public void onRegisterForge(ItemConfig eConfig) {
        ItemAction.register(eConfig, () -> {
            this.polish(eConfig);
            eConfig.onForgeRegistered();
            return null;
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onModelRegistryLoad(ModelRegistryEvent event) {
        for (ItemConfig config : MODEL_ENTRIES) {
            config.dynamicItemVariantLocation = config.registerDynamicModel();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onModelBakeEvent(ModelBakeEvent event) {
        for (ItemConfig config : MODEL_ENTRIES) {
            IDynamicModelElement dynamicModelElement = (IDynamicModelElement)config.getInstance();
            if (config.dynamicItemVariantLocation == null) continue;
            event.getModelRegistry().put(config.dynamicItemVariantLocation, dynamicModelElement.createDynamicModel(event));
        }
    }

    public static void handleItemModel(ItemConfig extendedConfig) {
        MODEL_ENTRIES.add(extendedConfig);
    }

    protected void polish(ItemConfig config) {
        IItemColor itemColorHandler;
        if (MinecraftHelpers.isClientSide() && (itemColorHandler = config.getItemColorHandler()) != null) {
            Minecraft.func_71410_x().getItemColors().func_199877_a(itemColorHandler, new IItemProvider[]{(IItemProvider)config.getInstance()});
        }
    }

    static {
        if (MinecraftHelpers.isClientSide()) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(ItemAction::onModelRegistryLoad);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(ItemAction::onModelBakeEvent);
        }
    }
}

