/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.collection;

import java.util.Objects;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollection;

public interface IIngredientCollectionMutable<T, M>
extends IIngredientCollection<T, M> {
    public boolean add(T var1);

    default public boolean addAll(Iterable<? extends T> instances) {
        boolean changed = false;
        for (T instance : instances) {
            changed |= this.add(instance);
        }
        return changed;
    }

    public boolean remove(T var1);

    public int removeAll(T var1, M var2);

    default public int removeAll(Iterable<? extends T> instances) {
        int removed = 0;
        for (T instance : instances) {
            if (!this.remove(instance)) continue;
            ++removed;
        }
        return removed;
    }

    default public int removeAll(Iterable<? extends T> instances, M matchCondition) {
        if (Objects.equals(this.getComponent().getMatcher().getAnyMatchCondition(), matchCondition)) {
            int size = this.size();
            this.clear();
            return size;
        }
        int removed = 0;
        for (T instance : instances) {
            removed += this.removeAll(instance, matchCondition);
        }
        return removed;
    }

    public void clear();
}

