/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.collection.diff;

import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollapsedCollectionMutable;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollectionMutable;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollectionAdapter;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollectionPrototypeMap;
import org.cyclops.cyclopscore.ingredient.collection.IngredientLinkedList;
import org.cyclops.cyclopscore.ingredient.collection.diff.IngredientCollectionDiff;

public class IngredientCollectionDiffHelpers {
    public static <T, M> IngredientCollectionDiff<T, M> getDiff(IngredientComponent<T, M> ingredientComponent, @Nullable IngredientCollectionPrototypeMap<T, M> oldInstancesCache, IngredientCollectionPrototypeMap<T, M> newInstancesCache, Iterator<T> newInstances) {
        boolean completelyEmpty;
        IIngredientMatcher matcher = ingredientComponent.getMatcher();
        boolean bl = completelyEmpty = !newInstances.hasNext();
        while (newInstances.hasNext()) {
            Object newInstance = newInstances.next();
            if (matcher.isEmpty(newInstance)) continue;
            newInstance = matcher.copy(newInstance);
            if (oldInstancesCache != null) {
                oldInstancesCache.remove(newInstance);
            }
            newInstancesCache.add(newInstance);
        }
        IngredientCollectionAdapter additions = new IngredientLinkedList<T, M>(ingredientComponent);
        IngredientLinkedList<Object, M> deletions = new IngredientLinkedList<Object, M>(ingredientComponent);
        if (oldInstancesCache != null) {
            Iterator<Map.Entry<T, Long>> quantitativeIterator = oldInstancesCache.prototypeIterator();
            while (quantitativeIterator.hasNext()) {
                long count;
                Map.Entry<T, Long> entry = quantitativeIterator.next();
                long l = count = entry.getValue() == null ? 0L : entry.getValue();
                if (count < 0L) {
                    additions.add(ingredientComponent.getMatcher().withQuantity(entry.getKey(), -count));
                    continue;
                }
                if (count <= 0L) continue;
                deletions.add(ingredientComponent.getMatcher().withQuantity(entry.getKey(), count));
            }
        } else {
            additions = newInstancesCache;
        }
        return new IngredientCollectionDiff<T, M>(additions, deletions, completelyEmpty);
    }

    public static <T, M> void applyDiff(IngredientComponent<T, M> ingredientComponent, IngredientCollectionDiff<T, M> diff, IIngredientCollectionMutable<T, M> collection) {
        IngredientCollectionPrototypeMap<T, M> prototypedIngredients;
        boolean applyDirectly = collection instanceof IIngredientCollapsedCollectionMutable;
        if (applyDirectly) {
            prototypedIngredients = (IngredientCollectionPrototypeMap<T, M>)collection;
        } else {
            prototypedIngredients = new IngredientCollectionPrototypeMap<T, M>(ingredientComponent);
            prototypedIngredients.addAll(collection);
        }
        if (diff.hasAdditions()) {
            prototypedIngredients.addAll(diff.getAdditions());
        }
        if (diff.hasDeletions()) {
            prototypedIngredients.removeAll(diff.getDeletions());
        }
        if (!applyDirectly) {
            collection.clear();
            collection.addAll(prototypedIngredients);
        }
    }
}

