/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.item;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.ItemFluidContainer;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;

public class DamageIndicatedItemComponent {
    public ItemFluidContainer item;

    public DamageIndicatedItemComponent(ItemFluidContainer item) {
        this.item = item;
    }

    public void fillItemGroup(ItemGroup itemGroup, NonNullList<ItemStack> items, Fluid fluid) {
        ItemStack itemStackFull = new ItemStack((IItemProvider)this.item);
        IFluidHandlerItemCapacity fluidHanderFull = (IFluidHandlerItemCapacity)FluidHelpers.getFluidHandlerItemCapacity(itemStackFull).orElse(null);
        if (fluidHanderFull != null) {
            fluidHanderFull.fill(new FluidStack(fluid, fluidHanderFull.getCapacity()), IFluidHandler.FluidAction.EXECUTE);
        }
        items.add((Object)itemStackFull);
        ItemStack itemStackEmpty = new ItemStack((IItemProvider)this.item);
        items.add((Object)itemStackEmpty);
    }

    public IFormattableTextComponent getInfo(ItemStack itemStack) {
        int amount = 0;
        IFluidHandlerItemCapacity fluidHander = (IFluidHandlerItemCapacity)FluidHelpers.getFluidHandlerItemCapacity(itemStack).orElse(null);
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)itemStack).orElse(FluidStack.EMPTY);
        if (!fluidStack.isEmpty()) {
            amount = fluidStack.getAmount();
        }
        return DamageIndicatedItemComponent.getInfo(fluidStack, amount, fluidHander == null ? 0 : fluidHander.getCapacity());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static IFormattableTextComponent getInfo(FluidStack fluidStack, int amount, int capacity) {
        StringTextComponent prefix = new StringTextComponent("");
        if (!fluidStack.isEmpty()) {
            prefix = new TranslationTextComponent(fluidStack.getTranslationKey()).func_240702_b_(": ");
        }
        return prefix.func_240702_b_(String.format("%,d", amount)).func_240702_b_(" / ").func_240702_b_(String.format("%,d", capacity)).func_240702_b_(" mB");
    }

    public void addInformation(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        list.add((ITextComponent)((IInformationProvider)itemStack.func_77973_b()).getInfo(itemStack).func_230530_a_(Style.field_240709_b_.func_240712_a_(IInformationProvider.ITEM_PREFIX)));
    }

    public double getDurability(ItemStack itemStack) {
        IFluidHandlerItemCapacity fluidHander = (IFluidHandlerItemCapacity)FluidHelpers.getFluidHandlerItemCapacity(itemStack).orElse(null);
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)itemStack).orElse(FluidStack.EMPTY);
        double capacity = fluidHander == null ? 0.0 : (double)fluidHander.getCapacity();
        double amount = FluidHelpers.getAmount(fluidStack);
        return (capacity - amount) / capacity;
    }
}

