/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.item;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.stats.Stat;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class ItemGui
extends Item {
    protected ItemGui(Item.Properties properties) {
        super(properties);
    }

    @Nullable
    public abstract INamedContainerProvider getContainer(World var1, PlayerEntity var2, int var3, Hand var4, ItemStack var5);

    public abstract Class<? extends Container> getContainerClass(World var1, PlayerEntity var2, ItemStack var3);

    public boolean onDroppedByPlayer(ItemStack itemstack, PlayerEntity player) {
        if (!itemstack.func_190926_b() && player instanceof ServerPlayerEntity && player.field_71070_bA != null && player.field_71070_bA.getClass() == this.getContainerClass(player.field_70170_p, player, itemstack)) {
            player.func_71053_j();
        }
        return super.onDroppedByPlayer(itemstack, player);
    }

    public void openGuiForItemIndex(World world, ServerPlayerEntity player, int itemIndex, Hand hand) {
        INamedContainerProvider containerProvider;
        if (!world.func_201670_d() && (containerProvider = this.getContainer(world, (PlayerEntity)player, itemIndex, hand, player.func_184586_b(hand))) != null) {
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)containerProvider, packetBuffer -> this.writeExtraGuiData((PacketBuffer)packetBuffer, world, player, itemIndex, hand));
            Stat<ResourceLocation> openStat = this.getOpenStat();
            if (openStat != null) {
                player.func_71029_a(openStat);
            }
        }
    }

    public void writeExtraGuiData(PacketBuffer packetBuffer, World world, ServerPlayerEntity player, int itemIndex, Hand hand) {
        packetBuffer.writeInt(itemIndex);
        packetBuffer.writeBoolean(hand == Hand.MAIN_HAND);
    }

    @Nullable
    protected Stat<ResourceLocation> getOpenStat() {
        return null;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (player instanceof FakePlayer) {
            return new ActionResult(ActionResultType.FAIL, (Object)itemStack);
        }
        if (player instanceof ServerPlayerEntity) {
            this.openGuiForItemIndex(world, (ServerPlayerEntity)player, player.field_71071_by.field_70461_c, hand);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemStack);
    }
}

