/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.item;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.cyclopscore.helper.L10NHelpers;

public class ItemInformationProvider {
    private static final Set<Item> ITEMS_INFO = Sets.newIdentityHashSet();

    public static void registerItem(Item item) {
        ITEMS_INFO.add(item);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        ItemStack itemStack = event.getItemStack();
        if (ITEMS_INFO.contains(itemStack.func_77973_b())) {
            L10NHelpers.addOptionalInfo(event.getToolTip(), itemStack.func_77977_a());
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register(ItemInformationProvider.class);
    }
}

