/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.entity.projectile;

import cofh.lib.util.AreaUtils;
import cofh.lib.util.Utils;
import cofh.lib.util.references.CoreReferences;
import cofh.thermal.core.init.TCoreReferences;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlizzProjectileEntity
extends DamagingProjectileEntity {
    private static final int CLOUD_DURATION = 20;
    public static float baseDamage = 5.0f;
    public static int effectAmplifier = 0;
    public static int effectDuration = 100;
    public static int effectRadius = 2;

    public BlizzProjectileEntity(EntityType<? extends DamagingProjectileEntity> type, World world) {
        super(type, world);
    }

    public BlizzProjectileEntity(LivingEntity shooter, double accelX, double accelY, double accelZ, World world) {
        super(TCoreReferences.BLIZZ_PROJECTILE_ENTITY, shooter, accelX, accelY, accelZ, world);
    }

    public BlizzProjectileEntity(double x, double y, double z, double accelX, double accelY, double accelZ, World world) {
        super(TCoreReferences.BLIZZ_PROJECTILE_ENTITY, x, y, z, accelX, accelY, accelZ, world);
    }

    protected boolean func_184564_k() {
        return false;
    }

    protected IParticleData func_195057_f() {
        return ParticleTypes.field_197593_D;
    }

    protected void func_70227_a(RayTraceResult result) {
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity entity = ((EntityRayTraceResult)result).func_216348_a();
            if (entity.func_70027_ad()) {
                entity.func_70066_B();
            }
            if (!entity.func_190530_aW() && entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.func_195064_c(new EffectInstance(CoreReferences.CHILLED, effectDuration, effectAmplifier, false, false));
            }
            entity.func_70097_a(BlizzDamageSource.causeDamage(this, this.func_234616_v_()), entity.func_230279_az_() ? baseDamage + 3.0f : baseDamage);
        }
        if (Utils.isServerWorld((World)this.field_70170_p)) {
            if (effectRadius > 0) {
                AreaUtils.freezeNearbyGround((Entity)this, (World)this.field_70170_p, (BlockPos)this.func_233580_cy_(), (int)effectRadius);
                AreaUtils.freezeSurfaceWater((Entity)this, (World)this.field_70170_p, (BlockPos)this.func_233580_cy_(), (int)effectRadius, (boolean)false);
                AreaUtils.freezeSurfaceLava((Entity)this, (World)this.field_70170_p, (BlockPos)this.func_233580_cy_(), (int)effectRadius, (boolean)false);
                this.makeAreaOfEffectCloud();
            }
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
    }

    protected void func_70088_a() {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private void makeAreaOfEffectCloud() {
        AreaEffectCloudEntity cloud = new AreaEffectCloudEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        cloud.func_184483_a(1.0f);
        cloud.func_195059_a((IParticleData)ParticleTypes.field_197593_D);
        cloud.func_184486_b(20);
        cloud.func_184485_d(0);
        cloud.func_184487_c(((float)effectRadius - cloud.func_184490_j()) / (float)cloud.func_184489_o());
        this.field_70170_p.func_217376_c((Entity)cloud);
    }

    protected static class BlizzDamageSource
    extends EntityDamageSource {
        public BlizzDamageSource(Entity source) {
            super("blizz", source);
        }

        public static DamageSource causeDamage(BlizzProjectileEntity entityProj, Entity entitySource) {
            return new IndirectEntityDamageSource("blizz", (Entity)entityProj, (Entity)(entitySource == null ? entityProj : entitySource)).func_76349_b();
        }
    }
}

