/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.entity.projectile;

import cofh.core.network.packet.client.PlayerMotionPacket;
import cofh.lib.entity.AbstractGrenadeEntity;
import cofh.lib.util.Utils;
import cofh.lib.util.references.CoreReferences;
import cofh.thermal.core.init.TCoreReferences;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class SlimeGrenadeEntity
extends AbstractGrenadeEntity {
    public static int effectDuration = 600;

    public SlimeGrenadeEntity(EntityType<? extends ProjectileItemEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public SlimeGrenadeEntity(World worldIn, double x, double y, double z) {
        super(TCoreReferences.SLIME_GRENADE_ENTITY, x, y, z, worldIn);
    }

    public SlimeGrenadeEntity(World worldIn, LivingEntity livingEntityIn) {
        super(TCoreReferences.SLIME_GRENADE_ENTITY, livingEntityIn, worldIn);
    }

    protected Item func_213885_i() {
        return TCoreReferences.SLIME_GRENADE_ITEM;
    }

    protected void func_70227_a(RayTraceResult result) {
        if (Utils.isServerWorld((World)this.field_70170_p)) {
            if (!this.func_70090_H()) {
                SlimeGrenadeEntity.affectNearbyEntities((Entity)this, this.field_70170_p, this.func_233580_cy_(), this.radius, this.func_234616_v_());
                this.makeAreaOfEffectCloud();
            }
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY && this.field_70173_aa < 10) {
            return;
        }
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 1.0, 0.0, 0.0);
        this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 0.5f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f, false);
    }

    private void makeAreaOfEffectCloud() {
        AreaEffectCloudEntity cloud = new AreaEffectCloudEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        cloud.func_184483_a(1.0f);
        cloud.func_195059_a((IParticleData)ParticleTypes.field_197592_C);
        cloud.func_184486_b(20);
        cloud.func_184485_d(0);
        cloud.func_184487_c(((float)this.radius - cloud.func_184490_j()) / (float)cloud.func_184489_o());
        this.field_70170_p.func_217376_c((Entity)cloud);
    }

    public static void affectNearbyEntities(Entity entity, World worldIn, BlockPos pos, int radius, @Nullable Entity source) {
        AxisAlignedBB area = new AxisAlignedBB(pos.func_177982_a(-radius, -radius, -radius), pos.func_177982_a(1 + radius, 1 + radius, 1 + radius));
        List mobs = worldIn.func_175647_a(LivingEntity.class, area, EntityPredicates.field_94557_a);
        for (LivingEntity mob : mobs) {
            double d9;
            double d7;
            mob.func_195064_c(new EffectInstance(CoreReferences.SLIMED, effectDuration, 0, false, true));
            double d5 = mob.func_226277_ct_() - entity.func_226277_ct_();
            double d13 = MathHelper.func_76133_a((double)(d5 * d5 + (d7 = mob.func_226278_cu_() - entity.func_226278_cu_()) * d7 + (d9 = mob.func_226281_cx_() - entity.func_226281_cx_()) * d9));
            if (d13 == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d12 = Math.sqrt(entity.func_70068_e((Entity)mob) / 32.0);
            double d14 = Explosion.func_222259_a((Vector3d)entity.func_213303_ch(), (Entity)mob);
            double d11 = ((double)radius - d12) * d14;
            d11 *= 1.0 - mob.func_233637_b_(Attributes.field_233820_c_);
            if (mob instanceof ServerPlayerEntity) {
                PlayerMotionPacket.sendToClient((double)(d5 * (d11 /= 4.0)), (double)(d7 * d11), (double)(d9 * d11), (ServerPlayerEntity)((ServerPlayerEntity)mob));
                continue;
            }
            mob.func_213317_d(mob.func_213322_ci().func_72441_c(d5 * d11, d7 * d11, d9 * d11));
        }
    }
}

