/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.item;

import cofh.core.item.BlockItemAugmentable;
import cofh.lib.energy.EnergyStorageCoFH;
import cofh.lib.energy.IEnergyContainerItem;
import cofh.lib.item.ContainerType;
import cofh.lib.util.helpers.AugmentDataHelper;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class BlockItemEnergyCell
extends BlockItemAugmentable
implements IEnergyContainerItem {
    public BlockItemEnergyCell(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
        this.setEnchantability(5);
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        boolean creative = this.isCreative(stack, ContainerType.ENERGY);
        if (this.getMaxEnergyStored(stack) > 0) {
            tooltip.add((ITextComponent)(creative ? StringHelper.getTextComponent((String)"info.cofh.infinite_source") : StringHelper.getTextComponent((String)(StringHelper.localize((String)"info.cofh.energy") + ": " + StringHelper.getScaledNumber((long)this.getEnergyStored(stack)) + " / " + StringHelper.getScaledNumber((long)this.getMaxEnergyStored(stack)) + " RF"))));
        }
        this.addEnergyTooltip(stack, worldIn, tooltip, flagIn, this.getExtract(stack), this.getReceive(stack), creative);
    }

    protected void setAttributesFromAugment(ItemStack container, CompoundNBT augmentData) {
        CompoundNBT subTag = container.func_179543_a("Properties");
        if (subTag == null) {
            return;
        }
        AugmentableHelper.setAttributeFromAugmentMax((CompoundNBT)subTag, (CompoundNBT)augmentData, (String)"BaseMod");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundNBT)subTag, (CompoundNBT)augmentData, (String)"RFMax");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundNBT)subTag, (CompoundNBT)augmentData, (String)"RFXfer");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundNBT)subTag, (CompoundNBT)augmentData, (String)"RFCre");
    }

    public CompoundNBT getOrCreateEnergyTag(ItemStack container) {
        CompoundNBT blockTag = container.func_190925_c("BlockEntityTag");
        if (!blockTag.func_74764_b("EnergyMax")) {
            new EnergyStorageCoFH(1000000, 1000, 1000).writeWithParams(container.func_190925_c("BlockEntityTag"));
        }
        return container.func_190925_c("BlockEntityTag");
    }

    public int getExtract(ItemStack container) {
        CompoundNBT tag = this.getOrCreateEnergyTag(container);
        float base = AugmentableHelper.getPropertyWithDefault((ItemStack)container, (String)"BaseMod", (float)1.0f);
        float mod = AugmentableHelper.getPropertyWithDefault((ItemStack)container, (String)"RFMax", (float)1.0f);
        return Math.round((float)tag.func_74762_e("EnergySend") * mod * base);
    }

    public int getReceive(ItemStack container) {
        CompoundNBT tag = this.getOrCreateEnergyTag(container);
        float base = AugmentableHelper.getPropertyWithDefault((ItemStack)container, (String)"BaseMod", (float)1.0f);
        float mod = AugmentableHelper.getPropertyWithDefault((ItemStack)container, (String)"RFMax", (float)1.0f);
        return Math.round((float)tag.func_74762_e("EnergyRecv") * mod * base);
    }

    public int getMaxEnergyStored(ItemStack container) {
        CompoundNBT tag = this.getOrCreateEnergyTag(container);
        float base = AugmentableHelper.getPropertyWithDefault((ItemStack)container, (String)"BaseMod", (float)1.0f);
        float mod = AugmentableHelper.getPropertyWithDefault((ItemStack)container, (String)"RFMax", (float)1.0f);
        return this.getMaxStored(container, Math.round((float)tag.func_74762_e("EnergyMax") * mod * base));
    }

    public void updateAugmentState(ItemStack container, List<ItemStack> augments) {
        container.func_196082_o().func_218657_a("Properties", (INBT)new CompoundNBT());
        for (ItemStack augment : augments) {
            CompoundNBT augmentData = AugmentDataHelper.getAugmentData((ItemStack)augment);
            if (augmentData == null) continue;
            this.setAttributesFromAugment(container, augmentData);
        }
        int energyExcess = this.getEnergyStored(container) - this.getMaxEnergyStored(container);
        if (energyExcess > 0) {
            this.setEnergyStored(container, this.getMaxEnergyStored(container));
        }
    }
}

