/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.item;

import cofh.core.item.ItemCoFH;
import cofh.lib.block.IDismantleable;
import cofh.lib.block.IWrenchable;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.references.CoreReferences;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class WrenchItem
extends ItemCoFH {
    private final Multimap<Attribute, AttributeModifier> toolAttributes;

    public WrenchItem(Item.Properties builder) {
        super(builder);
        ImmutableMultimap.Builder multimap = ImmutableMultimap.builder();
        multimap.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Tool modifier", 0.0, AttributeModifier.Operation.ADDITION));
        this.toolAttributes = multimap.build();
    }

    protected boolean useDelegate(ItemStack stack, ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        if (player == null || world.func_175623_d(pos)) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (player.func_226563_dT_() && block instanceof IDismantleable && ((IDismantleable)block).canDismantle(world, pos, state, player)) {
            if (Utils.isServerWorld((World)world)) {
                BlockRayTraceResult target = new BlockRayTraceResult(context.func_221532_j(), context.func_196000_l(), context.func_195995_a(), context.func_221533_k());
                ((IDismantleable)block).dismantleBlock(world, pos, state, (RayTraceResult)target, player, false);
            }
            player.func_184609_a(context.func_221531_n());
            return true;
        }
        if (!player.func_226563_dT_()) {
            if (block instanceof IWrenchable && ((IWrenchable)block).canWrench(world, pos, state, player)) {
                BlockRayTraceResult target = new BlockRayTraceResult(context.func_221532_j(), context.func_196000_l(), context.func_195995_a(), context.func_221533_k());
                ((IWrenchable)block).wrenchBlock(world, pos, state, (RayTraceResult)target, player);
                return true;
            }
            return BlockHelper.attemptRotateBlock((BlockState)state, (World)world, (BlockPos)pos);
        }
        return false;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        target.func_195064_c(new EffectInstance(CoreReferences.WRENCHED, 60, 0, false, false));
        stack.func_222118_a(1, attacker, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.FAIL;
        }
        return player.func_175151_a(context.func_195995_a(), context.func_196000_l(), context.func_195996_i()) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        return player.func_175151_a(context.func_195995_a(), context.func_196000_l(), stack) && this.useDelegate(stack, context) ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        return slot == EquipmentSlotType.MAINHAND ? this.toolAttributes : ImmutableMultimap.of();
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return new ItemStack((IItemProvider)this);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }
}

