/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.tileentity.device;

import cofh.core.client.renderer.model.ModelUtils;
import cofh.lib.util.StorageGroup;
import cofh.lib.util.helpers.AugmentDataHelper;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.lib.util.helpers.InventoryHelper;
import cofh.lib.xp.XpStorage;
import cofh.thermal.core.client.ThermalTextures;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.inventory.container.device.DeviceCollectorContainer;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.tileentity.DeviceTileBase;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.items.IItemHandler;

public class DeviceCollectorTile
extends DeviceTileBase
implements ITickableTileEntity {
    public static final BiPredicate<ItemStack, List<ItemStack>> AUG_VALIDATOR = ThermalAugmentRules.createAllowValidator("Upgrade", "Area", "Filter");
    protected static final int TIME_CONSTANT = 20;
    protected static final IModelData MODEL_DATA = new ModelDataMap.Builder().withInitial(ModelUtils.UNDERLAY, (Object)ThermalTextures.DEVICE_COLLECTOR_UNDERLAY_LOC).build();
    protected static final Predicate<ItemEntity> VALID_ITEM_ENTITY = item -> {
        if (!item.func_70089_S() || item.func_174874_s()) {
            return false;
        }
        CompoundNBT data = item.getPersistentData();
        return !data.func_74767_n("PreventRemoteMovement") || data.func_74767_n("AllowMachineRemoteMovement");
    };
    protected static final int RADIUS = 4;
    public int radius = 4;
    protected int process = 1;

    public DeviceCollectorTile() {
        super(TCoreReferences.DEVICE_COLLECTOR_TILE);
        this.inventory.addSlots(StorageGroup.ACCESSIBLE, 15, item -> this.filter.valid(item));
        this.xpStorage = new XpStorage(this.getBaseXpStorage());
        this.addAugmentSlots(ThermalConfig.deviceAugments);
        this.initHandlers();
    }

    @Override
    protected void updateActiveState(boolean prevActive) {
        if (!prevActive && this.isActive) {
            this.process = 1;
        }
        super.updateActiveState(prevActive);
    }

    public void func_73660_a() {
        this.updateActiveState();
        if (!this.isActive) {
            return;
        }
        --this.process;
        if (this.process > 0) {
            return;
        }
        this.process = this.getTimeConstant();
        this.collectItemsAndXp();
    }

    @Nonnull
    public IModelData getModelData() {
        return MODEL_DATA;
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new DeviceCollectorContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    public int getRadius() {
        return this.radius;
    }

    public int getTimeConstant() {
        return 20;
    }

    protected void collectItemsAndXp() {
        AxisAlignedBB area = new AxisAlignedBB(this.field_174879_c.func_177982_a(-this.radius, -1, -this.radius), this.field_174879_c.func_177982_a(1 + this.radius, 1 + this.radius, 1 + this.radius));
        this.collectItems(area);
        if (this.xpStorageFeature) {
            this.collectXpOrbs(area);
        }
    }

    protected void collectItems(AxisAlignedBB area) {
        IItemHandler handler = this.inventory.getHandler(StorageGroup.ACCESSIBLE);
        List items = this.field_145850_b.func_175647_a(ItemEntity.class, area, VALID_ITEM_ENTITY);
        Predicate filterRules = this.filter.getItemRules();
        for (ItemEntity item : items) {
            ItemStack entityStack = item.func_92059_d();
            if (!filterRules.test(entityStack)) continue;
            if ((entityStack = InventoryHelper.insertStackIntoInventory((IItemHandler)handler, (ItemStack)entityStack, (boolean)false)).func_190926_b()) {
                item.func_70106_y();
                continue;
            }
            item.func_92058_a(entityStack);
        }
    }

    protected void collectXpOrbs(AxisAlignedBB area) {
        List orbs = this.field_145850_b.func_175647_a(ExperienceOrbEntity.class, area, EntityPredicates.field_94557_a);
        for (ExperienceOrbEntity orb : orbs) {
            orb.field_70530_e -= this.xpStorage.receiveXp(orb.func_70526_d(), false);
            if (orb.field_70530_e > 0) continue;
            orb.func_70106_y();
        }
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && AUG_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }

    @Override
    protected void resetAttributes() {
        super.resetAttributes();
        this.radius = 4;
    }

    @Override
    protected void setAttributesFromAugment(CompoundNBT augmentData) {
        super.setAttributesFromAugment(augmentData);
        this.radius = (int)((float)this.radius + AugmentableHelper.getAttributeMod((CompoundNBT)augmentData, (String)"Radius"));
    }
}

