/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.tileentity.workbench;

import cofh.core.util.helpers.EnergyHelper;
import cofh.lib.energy.EnergyStorageCoFH;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.util.StorageGroup;
import cofh.lib.util.helpers.AugmentDataHelper;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.inventory.container.workbench.ChargeBenchContainer;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.tileentity.ThermalTileBase;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraftforge.energy.CapabilityEnergy;

public class ChargeBenchTile
extends ThermalTileBase
implements ITickableTileEntity {
    public static final BiPredicate<ItemStack, List<ItemStack>> AUG_VALIDATOR = ThermalAugmentRules.createAllowValidator("Upgrade", "RF", "Filter");
    public static final int BASE_CAPACITY = 500000;
    public static final int BASE_XFER = 4000;
    protected ItemStorageCoFH[] benchSlots = new ItemStorageCoFH[9];
    protected ItemStorageCoFH chargeSlot = new ItemStorageCoFH(1, EnergyHelper::hasEnergyHandlerCap);

    public ChargeBenchTile() {
        super(TCoreReferences.CHARGE_BENCH_TILE);
        this.energyStorage = new EnergyStorageCoFH(500000, 4000);
        for (int i = 0; i < this.benchSlots.length; ++i) {
            this.benchSlots[i] = new ItemStorageCoFH(1, EnergyHelper::hasEnergyHandlerCap);
            this.inventory.addSlot(this.benchSlots[i], StorageGroup.ACCESSIBLE);
        }
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.addAugmentSlots(ThermalConfig.storageAugments);
        this.initHandlers();
    }

    public void func_73660_a() {
        boolean curActive = this.isActive;
        this.isActive = false;
        if (this.redstoneControl().getState()) {
            this.chargeItems();
        }
        this.updateActiveState(curActive);
        this.chargeEnergy();
    }

    protected void chargeEnergy() {
        if (!this.chargeSlot.isEmpty()) {
            int maxTransfer = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getSpace());
            this.chargeSlot.getItemStack().getCapability(CapabilityEnergy.ENERGY, null).ifPresent(c -> this.energyStorage.receiveEnergy(c.extractEnergy(maxTransfer, false), false));
        }
    }

    protected void chargeItems() {
        for (ItemStorageCoFH benchSlot : this.benchSlots) {
            if (benchSlot.isEmpty()) continue;
            if (!this.energyStorage.isEmpty()) {
                int maxTransfer = Math.min(this.energyStorage.getMaxExtract(), this.energyStorage.getEnergyStored());
                benchSlot.getItemStack().getCapability(CapabilityEnergy.ENERGY, null).ifPresent(c -> this.energyStorage.extractEnergy(c.receiveEnergy(maxTransfer, false), false));
            }
            this.isActive = true;
        }
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new ChargeBenchContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && AUG_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }
}

