/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.common;

import cofh.thermal.core.tileentity.device.DeviceFisherTile;
import cofh.thermal.core.tileentity.device.DeviceTreeExtractorTile;
import cofh.thermal.lib.common.ThermalFlags;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ThermalConfig {
    private static boolean registered = false;
    private static final ForgeConfigSpec.Builder SERVER_CONFIG = new ForgeConfigSpec.Builder();
    private static ForgeConfigSpec serverSpec;
    private static final ForgeConfigSpec.Builder CLIENT_CONFIG;
    private static ForgeConfigSpec clientSpec;
    public static final byte[] DEFAULT_MACHINE_SIDES_RAW;
    public static final byte[] DEFAULT_CELL_SIDES_RAW;
    public static int deviceAugments;
    public static int dynamoAugments;
    public static int machineAugments;
    public static int storageAugments;
    public static int toolAugments;
    public static boolean permanentLava;
    public static boolean permanentWater;
    public static ForgeConfigSpec.BooleanValue enableVillagerTrades;
    public static ForgeConfigSpec.BooleanValue keepEnergy;
    public static ForgeConfigSpec.BooleanValue keepItems;
    public static ForgeConfigSpec.BooleanValue keepFluids;
    public static ForgeConfigSpec.BooleanValue keepAugments;
    public static ForgeConfigSpec.BooleanValue keepRSControl;
    public static ForgeConfigSpec.BooleanValue keepSideConfig;
    public static ForgeConfigSpec.BooleanValue keepTransferControl;
    public static ForgeConfigSpec.BooleanValue flagReconfigSides;
    public static ForgeConfigSpec.BooleanValue flagRSControl;
    public static ForgeConfigSpec.BooleanValue flagXPStorage;
    private static ForgeConfigSpec.BooleanValue flagVanillaBlocks;
    private static ForgeConfigSpec.BooleanValue flagRockwool;
    private static ForgeConfigSpec.BooleanValue flagMobBasalz;
    private static ForgeConfigSpec.BooleanValue flagMobBlitz;
    private static ForgeConfigSpec.BooleanValue flagMobBlizz;
    private static ForgeConfigSpec.BooleanValue worldGenApatite;
    private static ForgeConfigSpec.BooleanValue worldGenCinnabar;
    private static ForgeConfigSpec.BooleanValue worldGenNiter;
    private static ForgeConfigSpec.BooleanValue worldGenSulfur;
    private static ForgeConfigSpec.BooleanValue worldGenCopper;
    private static ForgeConfigSpec.BooleanValue worldGenTin;
    private static ForgeConfigSpec.BooleanValue worldGenLead;
    private static ForgeConfigSpec.BooleanValue worldGenSilver;
    private static ForgeConfigSpec.BooleanValue worldGenNickel;
    private static ForgeConfigSpec.BooleanValue worldGenOil;
    private static ForgeConfigSpec.BooleanValue freezePermanentLava;
    private static ForgeConfigSpec.BooleanValue freezePermanentWater;
    private static ForgeConfigSpec.IntValue deviceTreeExtractorTimeConstant;
    private static ForgeConfigSpec.IntValue deviceFisherTimeConstant;
    private static ForgeConfigSpec.IntValue deviceFisherTimeReductionWater;
    public static boolean jeiBucketTanks;
    public static boolean blockAmbientSounds;
    public static boolean mobAmbientSounds;
    public static ForgeConfigSpec.BooleanValue flagBlockAmbientSounds;
    public static ForgeConfigSpec.BooleanValue flagMobAmbientSounds;

    public static void register() {
        if (registered) {
            return;
        }
        FMLJavaModLoadingContext.get().getModEventBus().register(ThermalConfig.class);
        registered = true;
        ThermalConfig.genClientConfig();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, clientSpec);
    }

    public static void setup() {
        ThermalConfig.genServerConfig();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, serverSpec);
    }

    private ThermalConfig() {
    }

    private static void genServerConfig() {
        SERVER_CONFIG.push("Global Options");
        keepEnergy = SERVER_CONFIG.comment("If TRUE, most Thermal Blocks will retain Energy when dropped.\nThis setting does not control ALL blocks.").define("Blocks Retain Energy", true);
        keepItems = SERVER_CONFIG.comment("If TRUE, most Thermal Blocks will retain Inventory Contents when dropped.\nThis setting does not control ALL blocks.").define("Blocks Retain Inventory", false);
        keepFluids = SERVER_CONFIG.comment("If TRUE, most Thermal Blocks will retain Tank Contents when dropped.\nThis setting does not control ALL blocks.").define("Blocks Retain Tank Contents", false);
        keepAugments = SERVER_CONFIG.comment("If TRUE, Thermal Blocks will retain Augments when dropped.").define("Blocks Retain Augments", true);
        keepRSControl = SERVER_CONFIG.comment("If TRUE, Thermal Blocks will retain Redstone Control configuration when dropped.").define("Blocks Retain Redstone Control", true);
        keepSideConfig = SERVER_CONFIG.comment("If TRUE, Thermal Blocks will retain Side configuration when dropped.").define("Blocks Retain Side Configuration", true);
        keepTransferControl = SERVER_CONFIG.comment("If TRUE, Thermal Blocks will retain Transfer Control configuration when dropped.").define("Blocks Retain Transfer Control", true);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Features");
        flagVanillaBlocks = SERVER_CONFIG.comment("If TRUE, various 'Vanilla+' Blocks and Recipes are enabled.").define("Vanilla+", true);
        flagRockwool = SERVER_CONFIG.comment("If TRUE, Rockwool Blocks and Recipes are enabled.").define("Rockwool", true);
        flagMobBasalz = SERVER_CONFIG.comment("If TRUE, the Basalz Mob is enabled.").define("Basalz", true);
        flagMobBlitz = SERVER_CONFIG.comment("If TRUE, the Blitz Mob is enabled.").define("Blitz", true);
        flagMobBlizz = SERVER_CONFIG.comment("If TRUE, the Blizz Mob is enabled.").define("Blizz", true);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Augments");
        flagReconfigSides = SERVER_CONFIG.comment("If TRUE, Side Reconfiguration is enabled by default on most augmentable blocks which support it.\nIf FALSE, an augment is required.\nThis setting does not control ALL blocks.").define("Default Side Reconfiguration", true);
        flagRSControl = SERVER_CONFIG.comment("If TRUE, Redstone Control is enabled by default on most augmentable blocks which support it.\nIf FALSE, an augment is required.\nThis setting does not control ALL blocks.").define("Default Redstone Control", true);
        flagXPStorage = SERVER_CONFIG.comment("If TRUE, XP Storage is enabled by default on most augmentable blocks which support it.\nIf FALSE, an augment is required.\nThis setting does not control ALL blocks.").define("Default XP Storage", false);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Villagers");
        enableVillagerTrades = SERVER_CONFIG.comment("If TRUE, trades will be added to various Villagers.").define("Enable Villager Trades", true);
        SERVER_CONFIG.pop();
        ThermalConfig.genDeviceConfig();
        ThermalConfig.genWorldConfig();
        serverSpec = SERVER_CONFIG.build();
        ThermalConfig.refreshServerConfig();
    }

    private static void genClientConfig() {
        CLIENT_CONFIG.push("Sounds");
        flagBlockAmbientSounds = CLIENT_CONFIG.comment("If TRUE, some 'Thermal Series' Blocks will have ambient sounds.").define("Ambient Block Sounds", true);
        flagMobAmbientSounds = CLIENT_CONFIG.comment("If TRUE, some 'Thermal Series' Mobs will have ambient sounds.").define("Ambient Mob Sounds", true);
        CLIENT_CONFIG.pop();
        clientSpec = CLIENT_CONFIG.build();
        ThermalConfig.refreshClientConfig();
    }

    private static void genWorldConfig() {
        SERVER_CONFIG.push("World Generation");
        worldGenApatite = SERVER_CONFIG.comment("Set to FALSE to prevent 'Thermal Series' Apatite from generating.").define("Apatite", true);
        worldGenCinnabar = SERVER_CONFIG.comment("Set to FALSE to prevent 'Thermal Series' Cinnabar from generating.").define("Cinnabar", true);
        worldGenNiter = SERVER_CONFIG.comment("Set to FALSE to prevent 'Thermal Series' Niter from generating.").define("Niter", true);
        worldGenSulfur = SERVER_CONFIG.comment("Set to FALSE to prevent 'Thermal Series' Sulfur from generating.").define("Sulfur", true);
        worldGenCopper = SERVER_CONFIG.comment("Set to FALSE to prevent 'Thermal Series' Copper from generating.").define("Copper", true);
        worldGenTin = SERVER_CONFIG.comment("Set to FALSE to prevent 'Thermal Series' Tin from generating.").define("Tin", true);
        worldGenLead = SERVER_CONFIG.comment("Set to FALSE to prevent 'Thermal Series' Lead from generating.").define("Lead", true);
        worldGenSilver = SERVER_CONFIG.comment("Set to FALSE to prevent 'Thermal Series' Silver from generating.").define("Silver", true);
        worldGenNickel = SERVER_CONFIG.comment("Set to FALSE to prevent 'Thermal Series' Nickel from generating.").define("Nickel", true);
        worldGenOil = SERVER_CONFIG.comment("Set to FALSE to prevent 'Thermal Series' Oil Sands from generating.").define("Oil", true);
        SERVER_CONFIG.pop();
    }

    private static void genDeviceConfig() {
        SERVER_CONFIG.push("Devices");
        if (ThermalFlags.getFlag("device_tree_extractor").getAsBoolean()) {
            SERVER_CONFIG.push("TreeExtractor");
            deviceTreeExtractorTimeConstant = SERVER_CONFIG.comment("This sets the base time constant (in ticks) for the Arboreal Extractor.").defineInRange("Time Constant", 500, 20, 72000);
            SERVER_CONFIG.pop();
        }
        if (ThermalFlags.getFlag("device_fisher").getAsBoolean()) {
            SERVER_CONFIG.push("Fisher");
            deviceFisherTimeConstant = SERVER_CONFIG.comment("This sets the base time constant (in ticks) for the Aquatic Entangler.").defineInRange("Time Constant", 4800, 400, 72000);
            deviceFisherTimeReductionWater = SERVER_CONFIG.comment("This sets the time constant reduction (in ticks) per nearby Water source block for the Aquatic Entangler.").defineInRange("Water Source Time Constant Reduction", 20, 1, 1000);
            SERVER_CONFIG.pop();
        }
        SERVER_CONFIG.pop();
    }

    private static void genMachineConfig() {
    }

    private static void refreshServerConfig() {
        ThermalFlags.setFlag(ThermalFlags.FLAG_VANILLA_BLOCKS, (Boolean)flagVanillaBlocks.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_ROCKWOOL, (Boolean)flagRockwool.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_MOB_BASALZ, (Boolean)flagMobBasalz.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_MOB_BLITZ, (Boolean)flagMobBlitz.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_MOB_BLIZZ, (Boolean)flagMobBlizz.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_SIDE_CONFIG_AUGMENT, (Boolean)flagReconfigSides.get() == false);
        ThermalFlags.setFlag(ThermalFlags.FLAG_RS_CONTROL_AUGMENT, (Boolean)flagRSControl.get() == false);
        ThermalFlags.setFlag(ThermalFlags.FLAG_XP_STORAGE_AUGMENT, (Boolean)flagXPStorage.get() == false);
        ThermalConfig.refreshDeviceConfig();
        ThermalConfig.refreshWorldConfig();
    }

    private static void refreshDeviceConfig() {
        if (deviceTreeExtractorTimeConstant != null) {
            DeviceTreeExtractorTile.setTimeConstant((Integer)deviceTreeExtractorTimeConstant.get());
        }
        if (deviceFisherTimeConstant != null) {
            DeviceFisherTile.setTimeConstant((Integer)deviceFisherTimeConstant.get());
            DeviceFisherTile.setTimeReductionWater((Integer)deviceFisherTimeReductionWater.get());
        }
    }

    private static void refreshWorldConfig() {
        ThermalFlags.setFlag(ThermalFlags.FLAG_GEN_APATITE, () -> ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_APATITE).getAsBoolean() && (Boolean)worldGenApatite.get() != false);
        ThermalFlags.setFlag(ThermalFlags.FLAG_GEN_CINNABAR, () -> ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_CINNABAR).getAsBoolean() && (Boolean)worldGenCinnabar.get() != false);
        ThermalFlags.setFlag(ThermalFlags.FLAG_GEN_NITER, () -> ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_NITER).getAsBoolean() && (Boolean)worldGenNiter.get() != false);
        ThermalFlags.setFlag(ThermalFlags.FLAG_GEN_SULFUR, () -> ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_SULFUR).getAsBoolean() && (Boolean)worldGenSulfur.get() != false);
        ThermalFlags.setFlag(ThermalFlags.FLAG_GEN_COPPER, () -> ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_COPPER).getAsBoolean() && (Boolean)worldGenCopper.get() != false);
        ThermalFlags.setFlag(ThermalFlags.FLAG_GEN_TIN, () -> ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_TIN).getAsBoolean() && (Boolean)worldGenTin.get() != false);
        ThermalFlags.setFlag(ThermalFlags.FLAG_GEN_LEAD, () -> ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_LEAD).getAsBoolean() && (Boolean)worldGenLead.get() != false);
        ThermalFlags.setFlag(ThermalFlags.FLAG_GEN_SILVER, () -> ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_SILVER).getAsBoolean() && (Boolean)worldGenSilver.get() != false);
        ThermalFlags.setFlag(ThermalFlags.FLAG_GEN_NICKEL, () -> ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_NICKEL).getAsBoolean() && (Boolean)worldGenNickel.get() != false);
        ThermalFlags.setFlag(ThermalFlags.FLAG_GEN_OIL, () -> ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_OIL).getAsBoolean() && (Boolean)worldGenOil.get() != false);
    }

    private static void refreshClientConfig() {
        blockAmbientSounds = (Boolean)flagBlockAmbientSounds.get();
        mobAmbientSounds = (Boolean)flagMobAmbientSounds.get();
    }

    @SubscribeEvent
    public static void configLoading(ModConfig.Loading event) {
        switch (event.getConfig().getType()) {
            case CLIENT: {
                ThermalConfig.refreshClientConfig();
                break;
            }
            case SERVER: {
                ThermalConfig.refreshServerConfig();
            }
        }
    }

    @SubscribeEvent
    public static void configReloading(ModConfig.Reloading event) {
        switch (event.getConfig().getType()) {
            case CLIENT: {
                ThermalConfig.refreshClientConfig();
                break;
            }
            case SERVER: {
                ThermalConfig.refreshServerConfig();
            }
        }
    }

    static {
        CLIENT_CONFIG = new ForgeConfigSpec.Builder();
        DEFAULT_MACHINE_SIDES_RAW = new byte[]{0, 0, 0, 0, 0, 0};
        DEFAULT_CELL_SIDES_RAW = new byte[]{0, 0, 0, 0, 0, 0};
        deviceAugments = 3;
        dynamoAugments = 4;
        machineAugments = 4;
        storageAugments = 3;
        toolAugments = 4;
        permanentLava = true;
        permanentWater = true;
        jeiBucketTanks = true;
        blockAmbientSounds = true;
        mobAmbientSounds = true;
    }
}

