/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.compat.crt.actions;

import cofh.thermal.lib.util.recipes.ThermalFuel;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRecipeBase;
import com.blamejared.crafttweaker.impl.fluid.MCFluidStackMutable;
import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.registry.Registry;

public class ActionRemoveThermalFuelByOutput
extends ActionRecipeBase {
    private final IItemStack[] outputs;
    private final IFluidStack[] fluids;

    public ActionRemoveThermalFuelByOutput(IRecipeManager manager, IItemStack[] outputs) {
        super(manager);
        this.outputs = outputs;
        this.fluids = new IFluidStack[0];
    }

    public ActionRemoveThermalFuelByOutput(IRecipeManager manager, IFluidStack[] fluids) {
        super(manager);
        this.outputs = new IItemStack[0];
        this.fluids = fluids;
    }

    public ActionRemoveThermalFuelByOutput(IRecipeManager manager, IItemStack[] outputs, IFluidStack[] fluids) {
        super(manager);
        this.outputs = outputs;
        this.fluids = fluids;
    }

    public void apply() {
        Iterator iter = this.getManager().getRecipes().entrySet().iterator();
        while (iter.hasNext()) {
            int i;
            ThermalFuel fuel = (ThermalFuel)((Object)iter.next().getValue());
            if (fuel.getInputItems().size() != this.outputs.length || fuel.getInputFluids().size() != this.fluids.length) continue;
            boolean valid = true;
            for (i = 0; i < fuel.getInputItems().size(); ++i) {
                if (IIngredient.fromIngredient((Ingredient)fuel.getInputItems().get(i)).matches(this.outputs[i])) continue;
                valid = false;
                break;
            }
            for (i = 0; i < fuel.getInputFluids().size(); ++i) {
                if (this.fluids[i].containsOther((IFluidStack)new MCFluidStackMutable(fuel.getInputFluids().get(i))) || new MCFluidStackMutable(fuel.getInputFluids().get(i)).containsOther(this.fluids[i])) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            iter.remove();
        }
    }

    public String describe() {
        return "Removing \"" + Registry.field_218367_H.func_177774_c((Object)this.getManager().getRecipeType()) + "\" fuels with inputs: " + Arrays.toString(this.outputs) + "\" and fluid inputs: \"" + Arrays.toString(this.fluids) + "\"";
    }
}

