/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.tileentity;

import cofh.core.client.renderer.model.ModelUtils;
import cofh.core.tileentity.TileCoFH;
import cofh.core.util.control.IReconfigurableTile;
import cofh.core.util.control.ITransferControllableTile;
import cofh.core.util.control.ReconfigControlModule;
import cofh.core.util.control.TransferControlModule;
import cofh.core.util.helpers.EnergyHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.util.StorageGroup;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.control.IReconfigurable;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.InventoryHelper;
import cofh.thermal.lib.tileentity.ThermalTileBase;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class ReconfigurableTile4Way
extends ThermalTileBase
implements IReconfigurableTile,
ITransferControllableTile {
    protected ItemStorageCoFH chargeSlot = new ItemStorageCoFH(1, EnergyHelper::hasEnergyHandlerCap);
    protected int inputTracker;
    protected int outputTracker;
    protected ReconfigControlModule reconfigControl = new ReconfigControlModule((IReconfigurableTile)this);
    protected TransferControlModule transferControl = new TransferControlModule((ITransferControllableTile)this);
    protected boolean reconfigControlFeature = this.defaultReconfigState();
    protected LazyOptional<?> inputItemCap = LazyOptional.empty();
    protected LazyOptional<?> outputItemCap = LazyOptional.empty();
    protected LazyOptional<?> inputFluidCap = LazyOptional.empty();
    protected LazyOptional<?> outputFluidCap = LazyOptional.empty();

    public ReconfigurableTile4Way(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.reconfigControl.setEnabled(() -> this.reconfigControlFeature);
        this.transferControl.setEnabled(() -> this.reconfigControlFeature);
    }

    public TileCoFH worldContext(BlockState state, IBlockReader world) {
        this.reconfigControl.setFacing((Direction)state.func_177229_b((Property)Constants.FACING_HORIZONTAL));
        this.updateHandlers();
        return this;
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.updateSideCache();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.inputItemCap.invalidate();
        this.outputItemCap.invalidate();
        this.inputFluidCap.invalidate();
        this.outputFluidCap.invalidate();
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(ModelUtils.SIDES, (Object)this.reconfigControl().getRawSideConfig()).withInitial(ModelUtils.FLUID, (Object)this.renderFluid).build();
    }

    protected void updateSideCache() {
        Direction curFacing;
        Direction prevFacing = this.getFacing();
        if (prevFacing != (curFacing = (Direction)this.func_195044_w().func_177229_b((Property)Constants.FACING_HORIZONTAL))) {
            this.reconfigControl.setFacing(curFacing);
            int iPrev = prevFacing.func_176745_a();
            int iFace = curFacing.func_176745_a();
            IReconfigurable.SideConfig[] sides = new IReconfigurable.SideConfig[6];
            if (iPrev == BlockHelper.SIDE_RIGHT[iFace]) {
                for (int i = 0; i < 6; ++i) {
                    sides[i] = this.reconfigControl.getSideConfig()[BlockHelper.ROTATE_CLOCK_Y[i]];
                }
            } else if (iPrev == BlockHelper.SIDE_LEFT[iFace]) {
                for (int i = 0; i < 6; ++i) {
                    sides[i] = this.reconfigControl.getSideConfig()[BlockHelper.ROTATE_COUNTER_Y[i]];
                }
            } else if (iPrev == BlockHelper.SIDE_OPPOSITE[iFace]) {
                for (int i = 0; i < 6; ++i) {
                    sides[i] = this.reconfigControl.getSideConfig()[BlockHelper.INVERT_AROUND_Y[i]];
                }
            }
            this.reconfigControl.setSideConfig(sides);
        }
        this.updateHandlers();
    }

    protected void chargeEnergy() {
        if (!this.chargeSlot.isEmpty()) {
            this.chargeSlot.getItemStack().getCapability(CapabilityEnergy.ENERGY, null).ifPresent(c -> this.energyStorage.receiveEnergy(c.extractEnergy(Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getSpace()), false), false));
        }
    }

    protected void transferInput() {
        if (!this.transferControl.getTransferIn()) {
            return;
        }
        int newTracker = this.inputTracker;
        boolean updateTracker = false;
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            Direction side = Constants.DIRECTIONS[i % 6];
            if (!this.reconfigControl.getSideConfig(side).isInput()) continue;
            for (ItemStorageCoFH itemStorageCoFH : this.inputSlots()) {
                if (itemStorageCoFH.getSpace() <= 0) continue;
                InventoryHelper.extractFromAdjacent((TileEntity)this, (ItemStorageCoFH)itemStorageCoFH, (int)Math.min(this.getInputItemAmount(), itemStorageCoFH.getSpace()), (Direction)side);
            }
            for (FluidStorageCoFH fluidStorageCoFH : this.inputTanks()) {
                if (fluidStorageCoFH.getSpace() <= 0) continue;
                FluidHelper.extractFromAdjacent((TileEntity)this, (FluidStorageCoFH)fluidStorageCoFH, (int)Math.min(this.getInputFluidAmount(), fluidStorageCoFH.getSpace()), (Direction)side);
            }
            if (updateTracker) continue;
            newTracker = side.ordinal();
            updateTracker = true;
        }
        this.inputTracker = newTracker;
    }

    protected void transferOutput() {
        if (!this.transferControl.getTransferOut()) {
            return;
        }
        int newTracker = this.outputTracker;
        boolean updateTracker = false;
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            Direction side = Constants.DIRECTIONS[i % 6];
            if (!this.reconfigControl.getSideConfig(side).isOutput()) continue;
            for (ItemStorageCoFH itemStorageCoFH : this.outputSlots()) {
                InventoryHelper.insertIntoAdjacent((TileEntity)this, (ItemStorageCoFH)itemStorageCoFH, (int)this.getOutputItemAmount(), (Direction)side);
            }
            for (FluidStorageCoFH fluidStorageCoFH : this.outputTanks()) {
                FluidHelper.insertIntoAdjacent((TileEntity)this, (FluidStorageCoFH)fluidStorageCoFH, (int)this.getOutputFluidAmount(), (Direction)side);
            }
            if (updateTracker) continue;
            newTracker = side.ordinal();
            updateTracker = true;
        }
        this.outputTracker = newTracker;
    }

    protected int getInputItemAmount() {
        return 64;
    }

    protected int getOutputItemAmount() {
        return 64;
    }

    protected int getInputFluidAmount() {
        return 1000;
    }

    protected int getOutputFluidAmount() {
        return 1000;
    }

    @Override
    public void neighborChanged(Block blockIn, BlockPos fromPos) {
        super.neighborChanged(blockIn, fromPos);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        ModelDataManager.requestModelDataRefresh((TileEntity)this);
    }

    @Override
    public PacketBuffer getControlPacket(PacketBuffer buffer) {
        super.getControlPacket(buffer);
        this.reconfigControl.writeToBuffer(buffer);
        this.transferControl.writeToBuffer(buffer);
        return buffer;
    }

    @Override
    public void handleControlPacket(PacketBuffer buffer) {
        super.handleControlPacket(buffer);
        this.reconfigControl.readFromBuffer(buffer);
        this.transferControl.readFromBuffer(buffer);
        ModelDataManager.requestModelDataRefresh((TileEntity)this);
    }

    @Override
    public void handleStatePacket(PacketBuffer buffer) {
        super.handleStatePacket(buffer);
        ModelDataManager.requestModelDataRefresh((TileEntity)this);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.reconfigControl.setFacing(Direction.func_82600_a((int)nbt.func_74771_c("Facing")));
        this.reconfigControl.read(nbt);
        this.transferControl.read(nbt);
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.outputTracker = nbt.func_74762_e("TrackOut");
        this.updateHandlers();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("Facing", (byte)this.reconfigControl.getFacing().func_176745_a());
        this.reconfigControl.write(nbt);
        this.transferControl.write(nbt);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        return nbt;
    }

    @Override
    protected void resetAttributes() {
        super.resetAttributes();
        this.reconfigControlFeature = this.defaultReconfigState();
    }

    @Override
    protected void setAttributesFromAugment(CompoundNBT augmentData) {
        super.setAttributesFromAugment(augmentData);
        this.reconfigControlFeature |= AugmentableHelper.getAttributeMod((CompoundNBT)augmentData, (String)"SideCfg") > 0.0f;
    }

    @Override
    protected void finalizeAttributes(Map<Enchantment, Integer> enchantmentMap) {
        super.finalizeAttributes(enchantmentMap);
        if (!this.reconfigControlFeature) {
            this.transferControl.disable();
            this.reconfigControl.disable();
        }
    }

    public ReconfigControlModule reconfigControl() {
        return this.reconfigControl;
    }

    public TransferControlModule transferControl() {
        return this.transferControl;
    }

    @Override
    protected void updateHandlers() {
        super.updateHandlers();
        LazyOptional<?> prevItemInputCap = this.inputItemCap;
        LazyOptional<?> prevItemOutputCap = this.outputItemCap;
        IItemHandler inputInvHandler = this.inventory.getHandler(StorageGroup.INPUT);
        IItemHandler outputInvHandler = this.inventory.getHandler(StorageGroup.OUTPUT);
        this.inputItemCap = this.inventory.hasInputSlots() ? LazyOptional.of(() -> inputInvHandler) : LazyOptional.empty();
        this.outputItemCap = this.inventory.hasOutputSlots() ? LazyOptional.of(() -> outputInvHandler) : LazyOptional.empty();
        prevItemInputCap.invalidate();
        prevItemOutputCap.invalidate();
        LazyOptional<?> prevFluidInputCap = this.inputFluidCap;
        LazyOptional<?> prevFluidOutputCap = this.outputFluidCap;
        IFluidHandler inputFluidHandler = this.tankInv.getHandler(StorageGroup.INPUT);
        IFluidHandler outputFluidHandler = this.tankInv.getHandler(StorageGroup.OUTPUT);
        this.inputFluidCap = this.tankInv.hasInputTanks() ? LazyOptional.of(() -> inputFluidHandler) : LazyOptional.empty();
        this.outputFluidCap = this.tankInv.hasOutputTanks() ? LazyOptional.of(() -> outputFluidHandler) : LazyOptional.empty();
        prevFluidInputCap.invalidate();
        prevFluidOutputCap.invalidate();
    }

    @Override
    protected <T> LazyOptional<T> getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return super.getItemHandlerCapability(side);
        }
        switch (this.reconfigControl.getSideConfig(side)) {
            case SIDE_NONE: {
                return LazyOptional.empty();
            }
            case SIDE_INPUT: {
                return this.inputItemCap.cast();
            }
            case SIDE_OUTPUT: {
                return this.outputItemCap.cast();
            }
        }
        return super.getItemHandlerCapability(side);
    }

    @Override
    protected <T> LazyOptional<T> getFluidHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return super.getFluidHandlerCapability(side);
        }
        switch (this.reconfigControl.getSideConfig(side)) {
            case SIDE_NONE: {
                return LazyOptional.empty();
            }
            case SIDE_INPUT: {
                return this.inputFluidCap.cast();
            }
            case SIDE_OUTPUT: {
                return this.outputFluidCap.cast();
            }
        }
        return super.getFluidHandlerCapability(side);
    }

    @Override
    public void readConveyableData(PlayerEntity player, CompoundNBT tag) {
        this.reconfigControl.readSettings(tag);
        this.transferControl.readSettings(tag);
        super.readConveyableData(player, tag);
    }

    @Override
    public void writeConveyableData(PlayerEntity player, CompoundNBT tag) {
        this.reconfigControl.writeSettings(tag);
        this.transferControl.writeSettings(tag);
        super.writeConveyableData(player, tag);
    }
}

