/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window;

import java.util.Arrays;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.window.Window;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.View;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementButton;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementTextWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;

public class WindowPopup
extends Window<Workspace> {
    public WindowPopup(Workspace parent, String title, @Nullable Consumer<Workspace> callback, String ... text) {
        super(parent);
        this.setView(new ViewPopup(this, title, callback, text));
        this.disableDocking();
        this.disableDockStacking();
        this.disableUndocking();
        this.isNotUnique();
    }

    public static void popup(Workspace parent, double widthRatio, double heightRatio, Consumer<Workspace> callback, String ... text) {
        WindowPopup.popup(parent, widthRatio, heightRatio, "window.popup.title", callback, text);
    }

    public static void popup(Workspace parent, double widthRatio, double heightRatio, String title, Consumer<Workspace> callback, String ... text) {
        parent.openWindowInCenter(new WindowPopup(parent, title, callback, text), widthRatio, heightRatio, true);
    }

    public static class ViewPopup
    extends View<WindowPopup> {
        public ViewPopup(@Nonnull WindowPopup parent, String title, @Nullable Consumer<Workspace> callback, String ... text) {
            super(parent, title);
            ElementTextWrapper text1 = new ElementTextWrapper(this);
            if (text.length == 1) {
                text1.setText(text[0]);
            } else {
                text1.setText(Arrays.asList(text));
            }
            text1.setConstraint(new Constraint(text1).top(this, Constraint.Property.Type.TOP, 20).bottom(this, Constraint.Property.Type.BOTTOM, 40));
            this.elements.add(text1);
            ElementButton<ElementButton> button = new ElementButton<ElementButton>(this, I18n.func_135052_a((String)"gui.ok", (Object[])new Object[0]), elementClickable -> {
                ((Workspace)parent.parent).removeWindow(parent);
                if (callback != null) {
                    callback.accept((Workspace)parent.parent);
                }
            });
            button.setSize(60, 20);
            button.setConstraint(new Constraint(button).bottom(this, Constraint.Property.Type.BOTTOM, 20));
            this.elements.add(button);
        }

        @Override
        public void init() {
            super.init();
            ElementTextWrapper text = (ElementTextWrapper)this.elements.get(0);
            text.setWidth(Math.min(text.longestLine + 5, (int)((double)this.width * 0.9)));
            text.init();
        }

        @Override
        public void resize(Minecraft mc, int width, int height) {
            super.resize(mc, width, height);
            ElementTextWrapper text = (ElementTextWrapper)this.elements.get(0);
            text.setWidth(Math.min(text.longestLine + 5, (int)((double)this.width * 0.9)));
            text.init();
        }
    }
}

