/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.block.property;

import com.infinityraider.infinitylib.block.property.MirrorHandler;
import com.infinityraider.infinitylib.block.property.RotationHandler;
import com.infinityraider.infinitylib.utility.DirectionalConnectivity;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraftforge.common.IExtensibleEnum;
import net.minecraftforge.fluids.FluidStack;

public class InfProperty<T extends Comparable<T>> {
    private final Property<T> property;
    private final T defaultValue;
    private final MirrorHandler<T> mirrorHandler;
    private final RotationHandler<T> rotationHandler;

    private InfProperty(Property<T> property, T defaultValue, MirrorHandler<T> mirrorHandler, RotationHandler<T> rotationHandler) {
        this.property = property;
        this.defaultValue = defaultValue;
        this.mirrorHandler = mirrorHandler;
        this.rotationHandler = rotationHandler;
    }

    public final String getName() {
        return this.getProperty().func_177701_a();
    }

    public final T getDefaultValue() {
        return this.defaultValue;
    }

    public final Property<T> getProperty() {
        return this.property;
    }

    public final Collection<T> getAllowedValues() {
        return this.getProperty().func_177700_c();
    }

    protected StateContainer.Builder<Block, BlockState> apply(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{this.getProperty()});
        return builder;
    }

    public final BlockState apply(BlockState state) {
        return this.apply(state, this.getDefaultValue());
    }

    public final BlockState apply(BlockState state, T value) {
        return (BlockState)state.func_206870_a(this.getProperty(), value);
    }

    public final T fetch(BlockState state) {
        return (T)state.func_177229_b(this.getProperty());
    }

    public final BlockState mimic(BlockState from, BlockState to) {
        return this.apply(to, this.fetch(from));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return this.apply(state, (Comparable)this.mirrorHandler.handle(mirror, this.fetch(state)));
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return this.apply(state, (Comparable)this.rotationHandler.handle(rotation, this.fetch(state)));
    }

    /* synthetic */ InfProperty(Property x0, Comparable x1, MirrorHandler x2, RotationHandler x3, 1 x4) {
        this(x0, x1, x2, x3);
    }

    public static enum FluidLogged implements IStringSerializable,
    IExtensibleEnum
    {
        NONE(Fluids.field_204541_a),
        WATER((Fluid)Fluids.field_204546_a),
        LAVA((Fluid)Fluids.field_204547_b);

        private final Fluid fluid;

        private FluidLogged(Fluid fluid) {
            this.fluid = fluid;
        }

        public Fluid getFluid() {
            return this.fluid;
        }

        public boolean isEmpty() {
            return this == NONE;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public static boolean accepts(Fluid fluid) {
            return Arrays.stream(FluidLogged.values()).anyMatch(val -> val.getFluid().equals(fluid));
        }

        public static FluidLogged get(FluidState fluid) {
            return FluidLogged.get(fluid.func_206886_c());
        }

        public static FluidLogged get(FluidStack fluid) {
            return FluidLogged.get(fluid.getFluid());
        }

        public static FluidLogged get(Fluid fluid) {
            return Arrays.stream(FluidLogged.values()).filter(val -> val.getFluid() == fluid).findAny().orElse(NONE);
        }

        public static FluidLogged create(String name, Fluid fluid) {
            throw new IllegalStateException("Enum not extended");
        }
    }

    public static class Properties {

        public static final class Connectivity
        extends Property<DirectionalConnectivity> {
            public static Property<DirectionalConnectivity> create(String name) {
                return new Connectivity(name);
            }

            private Connectivity(String name) {
                super(name, DirectionalConnectivity.class);
            }

            public Collection<DirectionalConnectivity> func_177700_c() {
                return DirectionalConnectivity.ALL;
            }

            public String getName(DirectionalConnectivity value) {
                return value.toString();
            }

            public Optional<DirectionalConnectivity> func_185929_b(String value) {
                return Optional.empty();
            }
        }
    }

    public static final class Creators {
        private Creators() {
        }

        public static InfProperty<Boolean> create(String name, boolean defaultValue) {
            return Creators.create(BooleanProperty.func_177716_a((String)name), Boolean.valueOf(defaultValue));
        }

        public static InfProperty<Integer> create(String name, int def, int min, int max) {
            return Creators.create(IntegerProperty.func_177719_a((String)name, (int)min, (int)max), def);
        }

        public static InfProperty<Direction> create(String name, Direction defaultValue) {
            return Creators.create(DirectionProperty.func_196962_a((String)name, (Direction[])Direction.values()), defaultValue);
        }

        public static InfProperty<Direction> createHorizontals(String name, Direction defaultValue) {
            return Creators.create(DirectionProperty.func_177712_a((String)name, (Predicate)Direction.Plane.HORIZONTAL), defaultValue);
        }

        public static InfProperty<Direction.Axis> create(String name, Direction.Axis defaultValue) {
            return Creators.create((EnumProperty<Direction.Axis>)EnumProperty.func_177709_a((String)name, Direction.Axis.class), defaultValue);
        }

        public static InfProperty<Direction.Axis> createHorizontals(String name, Direction.Axis defaultValue) {
            return Creators.create((EnumProperty<Direction.Axis>)EnumProperty.func_177706_a((String)name, Direction.Axis.class, (Enum[])new Direction.Axis[]{Direction.Axis.X, Direction.Axis.Z}), defaultValue);
        }

        public static InfProperty<DirectionalConnectivity> create(String name, DirectionalConnectivity defaultValue) {
            return Creators.create(Properties.Connectivity.create(name), defaultValue);
        }

        public static <T extends Enum<T>> InfProperty<T> create(String name, Class<T> valueClass, T defaultValue) {
            return Creators.create(EnumProperty.func_177709_a((String)name, valueClass), defaultValue);
        }

        public static <T extends Enum<T>> InfProperty<T> create(String name, Class<T> valueClass, T defaultValue, Collection<T> allowedValues) {
            return Creators.create(EnumProperty.func_177707_a((String)name, valueClass, allowedValues), defaultValue);
        }

        public static <T extends Enum<T>> InfProperty<T> create(String name, Class<T> valueClass, T defaultValue, T ... allowedValues) {
            return Creators.create(EnumProperty.func_177706_a((String)name, valueClass, allowedValues), defaultValue);
        }

        public static <T extends Enum<T>> InfProperty<T> create(String name, Class<T> valueClass, T defaultValue, Predicate<T> allowedValues) {
            return Creators.create(EnumProperty.func_177708_a((String)name, valueClass, allowedValues), defaultValue);
        }

        public static <T extends Comparable<T>> InfProperty<T> create(Property<T> property, T defaultValue) {
            return Creators.create(property, defaultValue, MirrorHandler.Handlers.defaultHandler(), RotationHandler.Handlers.defaultHandler());
        }

        public static <T extends Comparable<T>> InfProperty<T> create(Property<T> property, T defaultValue, MirrorHandler<T> mirrorHandler) {
            return Creators.create(property, defaultValue, mirrorHandler, RotationHandler.Handlers.defaultHandler());
        }

        public static InfProperty<Direction> create(DirectionProperty property, Direction defaultValue) {
            return Creators.create(property, defaultValue, MirrorHandler.Handlers.direction(), RotationHandler.Handlers.direction());
        }

        public static InfProperty<Direction.Axis> create(EnumProperty<Direction.Axis> property, Direction.Axis defaultValue) {
            return Creators.create(property, defaultValue, RotationHandler.Handlers.axis());
        }

        public static <T extends Comparable<T>> InfProperty<T> create(Property<T> property, T defaultValue, RotationHandler<T> rotationHandler) {
            return Creators.create(property, defaultValue, MirrorHandler.Handlers.defaultHandler(), rotationHandler);
        }

        public static <T extends Comparable<T>> InfProperty<T> create(Property<T> property, T defaultValue, MirrorHandler<T> mirrorHandler, RotationHandler<T> rotationHandler) {
            return new InfProperty(property, defaultValue, mirrorHandler, rotationHandler, null);
        }
    }

    public static class Defaults {
        private static final InfProperty<Boolean> WATERLOGGED = Creators.create(BlockStateProperties.field_208198_y, Boolean.valueOf(false));
        private static final InfProperty<Boolean> LAVALOGGED = Creators.create(BooleanProperty.func_177716_a((String)"lavalogged"), Boolean.valueOf(false));
        private static final InfProperty<FluidLogged> FLUIDLOGGED = Creators.create(EnumProperty.func_177709_a((String)"fluilogged", FluidLogged.class), FluidLogged.NONE);
        private static final InfProperty<DirectionalConnectivity> CONNECTIVITY = Creators.create("connectivity", DirectionalConnectivity.NONE);

        private Defaults() {
        }

        public static InfProperty<Boolean> waterlogged() {
            return WATERLOGGED;
        }

        public static InfProperty<Boolean> lavalogged() {
            return LAVALOGGED;
        }

        public static InfProperty<FluidLogged> fluidlogged() {
            return FLUIDLOGGED;
        }

        public static InfProperty<DirectionalConnectivity> connectivity() {
            return CONNECTIVITY;
        }
    }
}

