/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.compat.jei;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.crafting.dynamictexture.IDynamicTextureIngredient;
import com.infinityraider.infinitylib.crafting.dynamictexture.ShapedDynamicTextureRecipe;
import com.infinityraider.infinitylib.item.BlockItemDynamicTexture;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.MethodsReturnNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.extensions.IExtendableRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICustomCraftingCategoryExtension;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.Size2i;

@OnlyIn(value=Dist.CLIENT)
@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    public static final ResourceLocation ID = new ResourceLocation(InfinityLib.instance.getModId(), "compat_jei");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        IExtendableRecipeCategory category = registration.getCraftingCategory();
        category.addCategoryExtension(ShapedDynamicTextureRecipe.class, Objects::nonNull, DynamicTextureRecipeExtension::new);
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        BlockItemDynamicTexture.getAll().forEach(item -> registration.registerSubtypeInterpreter((Item)item, (stack, context) -> {
            ResourceLocation id = item.getMaterial((ItemStack)stack).func_77973_b().getRegistryName();
            return id == null ? "unknown" : id.toString();
        }));
    }

    private static final class DynamicTextureRecipeExtension
    implements ICustomCraftingCategoryExtension {
        private final ShapedDynamicTextureRecipe recipe;

        public DynamicTextureRecipeExtension(ShapedDynamicTextureRecipe recipe) {
            this.recipe = recipe;
        }

        public void setIngredients(IIngredients ingredients) {
            List<Block> materials = this.recipe.getSuitableMaterials();
            ingredients.setInputLists(VanillaTypes.ITEM, this.recipe.func_192400_c().stream().map(ingredient -> {
                if (ingredient instanceof IDynamicTextureIngredient) {
                    return materials.stream().map(((IDynamicTextureIngredient)ingredient)::asStackWithMaterial).collect(Collectors.toList());
                }
                return Lists.newArrayList((Object[])ingredient.func_193365_a());
            }).collect(Collectors.toList()));
            ingredients.setOutputLists(VanillaTypes.ITEM, (List)ImmutableList.of(materials.stream().map(this.recipe::getResultWithMaterial).collect(Collectors.toList())));
        }

        public ResourceLocation getRegistryName() {
            return this.recipe.func_199560_c();
        }

        public Size2i getSize() {
            return new Size2i(this.recipe.getRecipeWidth(), this.recipe.getRecipeHeight());
        }

        public void setRecipe(IRecipeLayout layout, IIngredients ingredients) {
            layout.getIngredientsGroup(VanillaTypes.ITEM).setOverrideDisplayFocus(null);
            layout.getItemStacks().set(ingredients);
        }
    }
}

