/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.config;

import com.infinityraider.infinitylib.InfinityMod;
import java.io.File;
import java.util.function.Function;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigurationHandler<T extends SidedModConfig> {
    private final T config;
    private final ForgeConfigSpec spec;

    public ConfigurationHandler(ModLoadingContext context, Function<ForgeConfigSpec.Builder, T> constructor, InfinityMod<?, T> mod) {
        File modConfigDir = new File(FMLPaths.CONFIGDIR.get().toFile(), mod.getModId());
        if (!modConfigDir.exists() && !modConfigDir.mkdirs()) {
            throw new IllegalStateException("Could not evaluate config dir for " + mod.getModId());
        }
        Pair pair = new ForgeConfigSpec.Builder().configure(constructor);
        this.config = (SidedModConfig)pair.getLeft();
        this.spec = (ForgeConfigSpec)pair.getRight();
        context.registerConfig(this.getConfig().getSide(), this.getSpec(), mod.getModId() + "/config-" + this.getConfig().getSide().name().toLowerCase() + ".toml");
    }

    public T getConfig() {
        return this.config;
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }

    public static interface SidedModConfig {
        public ModConfig.Type getSide();
    }
}

