/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.crafting.dynamictexture;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.infinityraider.infinitylib.crafting.IInfIngredientSerializer;
import com.infinityraider.infinitylib.crafting.IInfRecipeSerializer;
import com.infinityraider.infinitylib.crafting.dynamictexture.DynamicTextureIngredient;
import com.infinityraider.infinitylib.crafting.dynamictexture.DynamicTextureParentIngredient;
import com.infinityraider.infinitylib.crafting.dynamictexture.IDynamicTextureIngredient;
import com.infinityraider.infinitylib.item.BlockItemDynamicTexture;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ShapedDynamicTextureRecipe
extends ShapedRecipe {
    public static final String ID = "crafting_shaped_dynamic_texture";
    public static final IRecipeSerializer<ShapedDynamicTextureRecipe> SERIALIZER = new Serializer();
    private List<Block> materials;

    public ShapedDynamicTextureRecipe(ShapedRecipe parent) {
        super(parent.func_199560_c(), parent.func_193358_e(), parent.getRecipeWidth(), parent.getRecipeHeight(), parent.func_192400_c(), parent.func_77571_b());
    }

    public List<Block> getSuitableMaterials() {
        if (this.materials == null) {
            this.materials = (List)this.func_192400_c().stream().filter(ingredient -> ingredient instanceof IDynamicTextureIngredient).findFirst().map(ingredient -> (IDynamicTextureIngredient)ingredient).map(IDynamicTextureIngredient::getTag).map(ITag::func_230236_b_).map(ImmutableList::copyOf).orElse(ImmutableList.of());
        }
        return this.materials;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ItemStack getResultWithoutMaterial() {
        return super.func_77571_b().func_77946_l();
    }

    public ItemStack getResultWithMaterial(Block block) {
        return this.getResultWithMaterial(new ItemStack((IItemProvider)block));
    }

    public ItemStack getResultWithMaterial(ItemStack material) {
        ItemStack stack = this.getResultWithoutMaterial();
        if (stack.func_77973_b() instanceof BlockItemDynamicTexture && material != null) {
            ((BlockItemDynamicTexture)stack.func_77973_b()).setMaterial(stack, material);
        }
        return stack;
    }

    public boolean func_192399_d() {
        return true;
    }

    public boolean func_77569_a(@Nonnull CraftingInventory inv, @Nonnull World world) {
        return this.checkMaterial(inv) != null;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull CraftingInventory inv) {
        return this.getResultWithMaterial(this.checkMaterial(inv));
    }

    @Nullable
    protected ItemStack checkMaterial(@Nonnull CraftingInventory inv) {
        for (int i = 0; i <= inv.func_174922_i() - this.getRecipeWidth(); ++i) {
            for (int j = 0; j <= inv.func_174923_h() - this.getRecipeHeight(); ++j) {
                ItemStack material = this.checkMaterialWithOffset(inv, i, j, true);
                if (material != null) {
                    return material;
                }
                material = this.checkMaterialWithOffset(inv, i, j, false);
                if (material == null) continue;
                return material;
            }
        }
        return null;
    }

    @Nullable
    protected ItemStack checkMaterialWithOffset(CraftingInventory craftingInventory, int width, int height, boolean flag) {
        ItemStack material = null;
        for (int i = 0; i < craftingInventory.func_174922_i(); ++i) {
            for (int j = 0; j < craftingInventory.func_174923_h(); ++j) {
                ItemStack stackInSlot;
                int k = i - width;
                int l = j - height;
                Ingredient ingredient = Ingredient.field_193370_a;
                if (k >= 0 && l >= 0 && k < this.getRecipeWidth() && l < this.getRecipeHeight()) {
                    ingredient = flag ? (Ingredient)this.func_192400_c().get(this.getRecipeWidth() - k - 1 + l * this.getRecipeWidth()) : (Ingredient)this.func_192400_c().get(k + l * this.getRecipeWidth());
                }
                if (!ingredient.test(stackInSlot = craftingInventory.func_70301_a(i + j * craftingInventory.func_174922_i()))) {
                    return null;
                }
                if (ingredient instanceof DynamicTextureIngredient) {
                    if (material == null) {
                        material = stackInSlot.func_77946_l();
                        material.func_190920_e(1);
                        continue;
                    }
                    if (ItemStack.func_179545_c((ItemStack)material, (ItemStack)stackInSlot)) continue;
                    return null;
                }
                if (!(ingredient instanceof DynamicTextureParentIngredient)) continue;
                ItemStack materialStack = ((BlockItemDynamicTexture)stackInSlot.func_77973_b()).getMaterial(stackInSlot);
                if (material == null) {
                    material = materialStack.func_77946_l();
                    material.func_190920_e(1);
                    continue;
                }
                if (ItemStack.func_179545_c((ItemStack)material, (ItemStack)materialStack)) continue;
                return null;
            }
        }
        return material;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ShapedDynamicTextureRecipe>,
    IInfRecipeSerializer {
        private Serializer() {
        }

        @Override
        @Nonnull
        public String getInternalName() {
            return ShapedDynamicTextureRecipe.ID;
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Nonnull
        public ShapedDynamicTextureRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            return this.convert((ShapedRecipe)IRecipeSerializer.field_222157_a.func_199425_a_(recipeId, json));
        }

        @Nullable
        public ShapedDynamicTextureRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
            return this.convert((ShapedRecipe)IRecipeSerializer.field_222157_a.func_199426_a_(recipeId, buffer));
        }

        protected ShapedDynamicTextureRecipe convert(@Nullable ShapedRecipe recipe) {
            return recipe == null ? null : new ShapedDynamicTextureRecipe(recipe);
        }

        public void write(@Nonnull PacketBuffer buffer, @Nonnull ShapedDynamicTextureRecipe recipe) {
            IRecipeSerializer.field_222157_a.func_199427_a_(buffer, (IRecipe)recipe);
        }

        public ImmutableList<IInfIngredientSerializer<?>> getIngredientSerializers() {
            return ImmutableList.of((Object)DynamicTextureIngredient.SERIALIZER, (Object)DynamicTextureParentIngredient.SERIALIZER);
        }
    }
}

