/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.entity;

import com.infinityraider.infinitylib.entity.IInfinityEntityType;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;

public interface IInfinityLivingEntityType
extends IInfinityEntityType {
    public AttributeModifierMap createCustomAttributes();

    default public Optional<SpawnEggData> getSpawnEggData() {
        return Optional.empty();
    }

    default public Set<SpawnRule> getSpawnRules() {
        return Collections.emptySet();
    }

    @Override
    default public EntityType<? extends LivingEntity> cast() {
        try {
            return (EntityType)this;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("IInfinityLivingEntityType must only be implemented in objects extending EntityType<? extends LivingEntity>");
        }
    }

    public static interface SpawnRule {
        public EntityClassification classification();

        public Predicate<Context> spawnRule();

        public int min();

        public int max();

        public int weight();

        public static interface Context {
            public IWorld world();

            public BlockPos pos();

            public BlockState stateBelow();

            public Biome biome();
        }
    }

    public static interface SpawnEggData {
        public int primaryColor();

        public int secondaryColor();

        @Nullable
        public ItemGroup tab();
    }
}

