/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.network;

import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.InfinityMod;
import com.infinityraider.infinitylib.network.INetworkWrapper;
import com.infinityraider.infinitylib.network.MessageBase;
import com.infinityraider.infinitylib.network.serialization.IMessageReader;
import com.infinityraider.infinitylib.network.serialization.IMessageSerializer;
import com.infinityraider.infinitylib.network.serialization.IMessageWriter;
import com.infinityraider.infinitylib.network.serialization.MessageSerializerStore;
import java.lang.reflect.Constructor;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class NetworkWrapper
implements INetworkWrapper {
    private static final String PROTOCOL_VERSION = "1";
    private final InfinityMod<?, ?> mod;
    private SimpleChannel channel;
    private int nextId = 0;

    public NetworkWrapper(InfinityMod<?, ?> mod) {
        this.mod = mod;
    }

    public void init() {
        this.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(this.mod.getModId(), "network_channel"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
        this.mod.registerMessages(this);
    }

    @Override
    public void sendToAll(MessageBase message) {
        if (message.getMessageDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            this.channel.send(PacketDistributor.ALL.noArg(), (Object)message);
        }
    }

    @Override
    public void sendTo(MessageBase message, ServerPlayerEntity player) {
        if (message.getMessageDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            this.channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)message);
        }
    }

    @Override
    public void sendToAllAround(MessageBase message, World world, double x, double y, double z, double range) {
        this.sendToAllAround(message, (RegistryKey<World>)world.func_234923_W_(), x, y, z, range);
    }

    @Override
    public void sendToAllAround(MessageBase message, RegistryKey<World> dimension, double x, double y, double z, double range) {
        if (message.getMessageDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            this.sendToAllAround(message, PacketDistributor.TargetPoint.p((double)x, (double)y, (double)z, (double)range, dimension));
        }
    }

    @Override
    public void sendToAllAround(MessageBase message, Supplier<PacketDistributor.TargetPoint> point) {
        if (message.getMessageDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            this.channel.send(PacketDistributor.NEAR.with(point), (Object)message);
        }
    }

    @Override
    public void sendToDimension(MessageBase message, World world) {
        this.sendToDimension(message, (RegistryKey<World>)world.func_234923_W_());
    }

    @Override
    public void sendToDimension(MessageBase message, RegistryKey<World> dimension) {
        if (message.getMessageDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            this.channel.send(PacketDistributor.DIMENSION.with(() -> dimension), (Object)message);
        }
    }

    @Override
    public void sendToServer(MessageBase message) {
        if (message.getMessageDirection() == NetworkDirection.PLAY_TO_SERVER) {
            this.channel.send(PacketDistributor.SERVER.noArg(), (Object)message);
        }
    }

    public <MSG extends MessageBase> void registerMessage(Class<MSG> msgClass) {
        try {
            Constructor<MSG> msgConstructor = msgClass.getDeclaredConstructor(new Class[0]);
            MessageBase msg = (MessageBase)msgConstructor.newInstance(new Object[0]);
            msg.getNecessarySerializers().stream().forEach(this::registerDataSerializer);
            this.channel.registerMessage(this.nextId, msgClass, new MessageEncoder(), new MessageDecoder(msgConstructor), new MessageHandler(), Optional.ofNullable(msg.getMessageDirection()));
            InfinityLib.instance.getLogger().debug("Registered message \"" + msgClass.getName() + "\" with id " + this.nextId, new Object[0]);
            ++this.nextId;
            MessageBase.onMessageRegistered(msgClass, this);
        }
        catch (Exception e) {
            InfinityLib.instance.getLogger().printStackTrace(e);
        }
    }

    @Override
    public <T> void registerDataSerializer(Class<T> clazz, IMessageWriter<T> writer, IMessageReader<T> reader) {
        MessageSerializerStore.registerMessageSerializer(clazz, writer, reader);
    }

    @Override
    public <T> void registerDataSerializer(IMessageSerializer<T> serializer) {
        MessageSerializerStore.registerMessageSerializer(serializer);
    }

    private static class MessageTask
    implements Runnable {
        private final MessageBase message;
        private final NetworkEvent.Context ctx;

        private MessageTask(MessageBase message, NetworkEvent.Context ctx) {
            this.message = message;
            this.ctx = ctx;
        }

        @Override
        public void run() {
            if (this.message.getMessageDirection() == this.ctx.getDirection()) {
                this.message.processMessage(this.ctx);
            }
            this.ctx.setPacketHandled(true);
        }
    }

    private static final class MessageHandler<MSG extends MessageBase>
    implements BiConsumer<MSG, Supplier<NetworkEvent.Context>> {
        private MessageHandler() {
        }

        @Override
        public void accept(MSG msg, Supplier<NetworkEvent.Context> ctxSupplier) {
            NetworkEvent.Context ctx = ctxSupplier.get();
            ctx.enqueueWork((Runnable)new MessageTask((MessageBase)msg, ctxSupplier.get()));
        }
    }

    private static class MessageDecoder<MSG extends MessageBase>
    implements Function<PacketBuffer, MSG> {
        private final Constructor<MSG> msgConstructor;

        private MessageDecoder(Constructor<MSG> msgConstructor) {
            this.msgConstructor = msgConstructor;
        }

        @Override
        public MSG apply(PacketBuffer buf) {
            try {
                return (MSG)((MessageBase)this.msgConstructor.newInstance(new Object[0])).fromBytes(buf);
            }
            catch (Exception e) {
                InfinityLib.instance.getLogger().printStackTrace(e);
                return null;
            }
        }
    }

    private static class MessageEncoder<MSG extends MessageBase>
    implements BiConsumer<MSG, PacketBuffer> {
        private MessageEncoder() {
        }

        @Override
        public void accept(MSG req, PacketBuffer packetBuffer) {
            ((MessageBase)req).toBytes(packetBuffer);
        }
    }
}

