/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.particle;

import com.google.common.collect.Sets;
import com.infinityraider.infinitylib.particle.IInfinityParticleType;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.particles.IParticleData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;

@OnlyIn(value=Dist.CLIENT)
public class ParticleHelper {
    private static final ParticleHelper INSTANCE = new ParticleHelper();
    private final Set<IInfinityParticleType<?>> types = Sets.newConcurrentHashSet();

    public static ParticleHelper getInstance() {
        return INSTANCE;
    }

    private ParticleHelper() {
    }

    public <T extends IParticleData> void registerType(IInfinityParticleType<T> type) {
        this.types.add(type);
    }

    public void onFactoryRegistration(ParticleFactoryRegisterEvent event) {
        this.types.forEach(this::registerFactory);
    }

    protected <T extends IParticleData> void registerFactory(IInfinityParticleType<T> type) {
        Minecraft.func_71410_x().field_71452_i.func_199283_a(type.cast(), type.particleFactorySupplier().supplyFactory());
    }
}

