/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.sound;

import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.proxy.IProxy;
import com.infinityraider.infinitylib.sound.IModSound;
import com.infinityraider.infinitylib.sound.MessagePlaySound;
import com.infinityraider.infinitylib.sound.MessageStopSound;
import com.infinityraider.infinitylib.sound.ModSoundAtEntity;
import com.infinityraider.infinitylib.sound.ModSoundAtPosition;
import com.infinityraider.infinitylib.sound.SidedSoundDelegate;
import com.infinityraider.infinitylib.sound.SoundTask;
import com.infinityraider.infinitylib.sound.SoundTaskClient;
import io.netty.util.internal.ThreadLocalRandom;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ISoundEventListener;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.entity.Entity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class SoundDelegateClient
extends SidedSoundDelegate
implements ISoundEventListener {
    private final SoundHandler handler;
    private final Map<String, IModSound> soundMap;
    private final Set<String> cleanupPool;

    public SoundDelegateClient(SoundHandler handler) {
        this.handler = handler;
        this.soundMap = new HashMap<String, IModSound>();
        this.cleanupPool = new HashSet<String>();
        this.handler.func_184402_a((ISoundEventListener)this);
        ((IProxy)InfinityLib.instance.proxy()).registerEventHandler(this);
    }

    public void func_184067_a(ISound soundIn, SoundEventAccessor accessor) {
    }

    @Override
    public SoundTask playSoundAtPositionOnce(Vector3d position, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        SoundTaskClient soundTask = new SoundTaskClient(MathHelper.func_180182_a((Random)ThreadLocalRandom.current()).toString(), sound, category, volume, pitch).setRepeat(false);
        ModSoundAtPosition soundImpl = new ModSoundAtPosition(this, position, soundTask);
        this.handleSoundPlay(soundTask, soundImpl);
        return soundTask;
    }

    @Override
    public SoundTaskClient playSoundAtEntityOnce(Entity entity, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        SoundTaskClient soundTask = new SoundTaskClient(MathHelper.func_180182_a((Random)ThreadLocalRandom.current()).toString(), sound, category, volume, pitch).setRepeat(false);
        ModSoundAtEntity soundImpl = new ModSoundAtEntity(this, entity, soundTask);
        this.handleSoundPlay(soundTask, soundImpl);
        return soundTask;
    }

    @Override
    public SoundTask playSoundAtPositionContinuous(Vector3d position, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        SoundTaskClient soundTask = new SoundTaskClient(MathHelper.func_180182_a((Random)ThreadLocalRandom.current()).toString(), sound, category, volume, pitch).setRepeat(true).setRepeatDelay(0);
        ModSoundAtPosition soundImpl = new ModSoundAtPosition(this, position, soundTask);
        this.handleSoundPlay(soundTask, soundImpl);
        return soundTask;
    }

    @Override
    public SoundTaskClient playSoundAtEntityContinuous(Entity entity, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        SoundTaskClient soundTask = new SoundTaskClient(MathHelper.func_180182_a((Random)ThreadLocalRandom.current()).toString(), sound, category, volume, pitch).setRepeat(true).setRepeatDelay(0);
        ModSoundAtEntity soundImpl = new ModSoundAtEntity(this, entity, soundTask);
        this.handleSoundPlay(soundTask, soundImpl);
        return soundTask;
    }

    protected void handleSoundPlay(SoundTaskClient soundTask, IModSound sound) {
        this.soundMap.put(soundTask.getUUID(), sound);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
    }

    @Override
    public void stopSound(SoundTask task) {
        this.stopSound(task.getUUID());
    }

    @Override
    void onSoundMessage(MessagePlaySound message) {
        SoundTaskClient soundTask = message.getModSound();
        switch (message.getType()) {
            case ENTITY: {
                this.handleSoundPlay(soundTask, new ModSoundAtEntity(this, message.getEntity(), soundTask));
                break;
            }
            case POSITION: {
                this.handleSoundPlay(soundTask, new ModSoundAtPosition(this, message.getPosition(), soundTask));
            }
        }
    }

    @Override
    void onSoundMessage(MessageStopSound message) {
        this.stopSound(message.getUUID());
    }

    protected void stopSound(String UUID2) {
        if (this.soundMap.containsKey(UUID2)) {
            this.soundMap.remove(UUID2).stop();
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.cleanupPool.addAll(this.soundMap.keySet());
        } else {
            this.cleanupPool.forEach(this.soundMap::remove);
            this.cleanupPool.clear();
        }
    }

    void onSoundTick(IModSound sound) {
        this.cleanupPool.remove(sound.getUUID());
    }
}

