/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.utility;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;

public class HashableBlockState {
    @Nonnull
    private final Block block;
    @Nullable
    private final Direction side;
    @Nonnull
    private final Collection<Property<?>> properties;

    public HashableBlockState(@Nonnull BlockState state) {
        this(state, null);
    }

    public HashableBlockState(@Nonnull BlockState state, @Nullable Direction side) {
        this(state.func_177230_c(), state.func_235904_r_(), side);
    }

    public HashableBlockState(@Nonnull Block block, @Nonnull Collection<Property<?>> properties, @Nullable Direction side) {
        this.block = (Block)Preconditions.checkNotNull((Object)block);
        this.properties = (Collection)Preconditions.checkNotNull(properties);
        this.side = side;
    }

    public boolean equals(Object obj) {
        if (obj instanceof HashableBlockState) {
            HashableBlockState other = (HashableBlockState)obj;
            return Objects.equals(this.block, other.block) && Objects.equals(this.side, other.side) && Objects.equals(this.properties, other.properties);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Objects.hashCode(this.block);
        hash = 31 * hash + Objects.hashCode(this.side);
        hash = 31 * hash + Objects.hashCode(this.properties);
        return hash;
    }
}

