/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.initialinventory;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.actions.IUndoableAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import com.blamejared.initialinventory.InitialInventory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.initialinventory.InvHandler")
@ZenRegister
public class InvHandler {
    @ZenCodeType.Method
    public static void addStartingItem(String key, IItemStack item, @ZenCodeType.OptionalInt(value=-1) int slotId) {
        CraftTweakerAPI.apply((IAction)new AddItem(key, item.getInternal(), slotId));
    }

    private static class AddItem
    implements IUndoableAction {
        private final String key;
        private final ItemStack stack;
        private final int index;

        public AddItem(String key, ItemStack stack, int index) {
            this.key = key;
            this.stack = stack;
            this.index = index;
        }

        public void apply() {
            List list = InitialInventory.STACK_MAP.computeIfAbsent(this.key, s -> new ArrayList());
            list.add(Pair.of((Object)this.stack, (Object)this.index));
        }

        public String describe() {
            return String.format("Adding starting item: %s in slot: %s in key: %s", new MCItemStackMutable(this.stack).getCommandString(), this.index, this.key);
        }

        public void undo() {
            List list = InitialInventory.STACK_MAP.computeIfAbsent(this.key, s -> new ArrayList());
            list.removeIf(itemStackIntegerPair -> new MCItemStackMutable((ItemStack)itemStackIntegerPair.getKey()).matches((IItemStack)new MCItemStackMutable(this.stack)));
        }

        public String describeUndo() {
            return String.format("Removing starting item: %s in slot: %s in key: %s", new MCItemStackMutable(this.stack).getCommandString(), this.index, this.key);
        }
    }
}

