/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import vazkii.patchouli.client.base.ClientAdvancements;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.Book;

public abstract class BookPage {
    public transient Minecraft mc;
    public transient FontRenderer fontRenderer;
    public transient GuiBookEntry parent;
    public transient Book book;
    protected transient BookEntry entry;
    protected transient int pageNum;
    private transient List<Button> buttons;
    public transient int left;
    public transient int top;
    public transient JsonObject sourceObject;
    protected String type;
    protected String flag;
    protected String advancement;
    protected String anchor;

    public void build(BookEntry entry, int pageNum) {
        this.book = entry.getBook();
        this.entry = entry;
        this.pageNum = pageNum;
    }

    public void onDisplayed(GuiBookEntry parent, int left, int top) {
        this.mc = parent.getMinecraft();
        this.book = parent.book;
        this.fontRenderer = this.mc.field_71466_p;
        this.parent = parent;
        this.left = left;
        this.top = top;
        this.buttons = new ArrayList<Button>();
    }

    public boolean isPageUnlocked() {
        return this.advancement == null || this.advancement.isEmpty() || ClientAdvancements.hasDone(this.advancement);
    }

    public void onHidden(GuiBookEntry parent) {
        parent.removeButtonsIn(this.buttons);
    }

    protected void addButton(Button button) {
        button.field_230690_l_ += this.parent.bookLeft + this.left;
        button.field_230691_m_ += this.parent.bookTop + this.top;
        this.buttons.add(button);
        this.parent.func_230480_a_(button);
    }

    public void render(MatrixStack ms, int mouseX, int mouseY, float pticks) {
    }

    public boolean func_231043_a_(double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    public boolean canAdd(Book book) {
        return this.flag == null || this.flag.isEmpty() || PatchouliConfig.getConfigFlag(this.flag);
    }

    public String i18n(String text) {
        return this.book.i18n ? I18n.func_135052_a((String)text, (Object[])new Object[0]) : text;
    }

    public ITextComponent i18nText(String text) {
        return this.book.i18n ? new TranslationTextComponent(text) : new StringTextComponent(text);
    }
}

