/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.obfuscate.common.data;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.obfuscate.common.data.SyncedDataKey;
import com.mrcrayfish.obfuscate.network.HandshakeMessages;
import com.mrcrayfish.obfuscate.network.PacketHandler;
import com.mrcrayfish.obfuscate.network.message.MessageSyncPlayerData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.commons.lang3.Validate;

public class SyncedPlayerData {
    @CapabilityInject(value=DataHolder.class)
    public static final Capability<DataHolder> CAPABILITY = null;
    private static SyncedPlayerData instance;
    private static boolean init;
    private final Map<ResourceLocation, SyncedDataKey<?>> registeredDataKeys = new HashMap();
    private final Map<Integer, SyncedDataKey<?>> idToDataKey = new HashMap();
    private int nextKeyId = 0;
    private boolean dirty = false;

    private SyncedPlayerData() {
    }

    public static SyncedPlayerData instance() {
        if (instance == null) {
            instance = new SyncedPlayerData();
        }
        return instance;
    }

    public static void init() {
        if (!init) {
            CapabilityManager.INSTANCE.register(DataHolder.class, (Capability.IStorage)new Storage(), DataHolder::new);
            MinecraftForge.EVENT_BUS.register((Object)SyncedPlayerData.instance());
            init = true;
        }
    }

    public void registerKey(SyncedDataKey<?> key) {
        if (this.registeredDataKeys.containsKey(key.getKey())) {
            throw new IllegalArgumentException(String.format("The data key '%s' is already registered!", key.getKey()));
        }
        int nextId = this.nextKeyId++;
        key.setId(nextId);
        this.registeredDataKeys.put(key.getKey(), key);
        this.idToDataKey.put(nextId, key);
    }

    public <T> void set(PlayerEntity player, SyncedDataKey<T> key, T value) {
        if (!this.registeredDataKeys.values().contains(key)) {
            throw new IllegalArgumentException(String.format("The data key '%s' is not registered!", key.getKey()));
        }
        DataHolder holder = this.getDataHolder(player);
        if (holder != null && holder.set(player, key, value) && !player.field_70170_p.field_72995_K) {
            this.dirty = true;
        }
    }

    public <T> T get(PlayerEntity player, SyncedDataKey<T> key) {
        if (!this.registeredDataKeys.values().contains(key)) {
            throw new IllegalArgumentException(String.format("The data key '%s' is not registered!", key.getKey()));
        }
        DataHolder holder = this.getDataHolder(player);
        return (T)(holder != null ? holder.get(key) : key.getDefaultValueSupplier().get());
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T> void updateClientEntry(PlayerEntity player, DataEntry<T> entry) {
        SyncedPlayerData.instance().set(player, ((DataEntry)entry).getKey(), ((DataEntry)entry).getValue());
    }

    @Nullable
    private SyncedDataKey<?> getKey(int id) {
        return this.idToDataKey.get(id);
    }

    public List<SyncedDataKey<?>> getKeys() {
        return ImmutableList.copyOf(this.registeredDataKeys.values());
    }

    @Nullable
    private DataHolder getDataHolder(PlayerEntity player) {
        return (DataHolder)player.getCapability(CAPABILITY, null).orElse(null);
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(new ResourceLocation("obfuscate", "synced_player_data"), (ICapabilityProvider)new Provider());
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        PlayerEntity player;
        DataHolder holder;
        if (event.getTarget() instanceof PlayerEntity && !event.getPlayer().field_70170_p.field_72995_K && (holder = this.getDataHolder(player = (PlayerEntity)event.getTarget())) != null) {
            List entries = holder.gatherAll();
            entries.removeIf(entry -> !((DataEntry)entry).getKey().shouldSyncToAllPlayers());
            if (!entries.isEmpty()) {
                PacketHandler.getPlayChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new MessageSyncPlayerData(player.func_145782_y(), entries));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerJoinWorld(EntityJoinWorldEvent event) {
        List entries;
        PlayerEntity player;
        DataHolder holder;
        Entity entity = event.getEntity();
        if (entity instanceof PlayerEntity && !event.getWorld().field_72995_K && (holder = this.getDataHolder(player = (PlayerEntity)entity)) != null && !(entries = holder.gatherAll()).isEmpty()) {
            PacketHandler.getPlayChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageSyncPlayerData(player.func_145782_y(), entries));
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        PlayerEntity original = event.getOriginal();
        if (!original.field_70170_p.field_72995_K) {
            DataHolder newHolder;
            PlayerEntity player = event.getPlayer();
            DataHolder oldHolder = this.getDataHolder(original);
            if (oldHolder != null && (newHolder = this.getDataHolder(player)) != null) {
                HashMap dataMap = new HashMap(oldHolder.dataMap);
                if (event.isWasDeath()) {
                    dataMap.entrySet().removeIf(entry -> !((SyncedDataKey)entry.getKey()).isPersistent());
                }
                newHolder.dataMap = dataMap;
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.dirty) {
            DataHolder holder;
            PlayerEntity player = event.player;
            if (!player.field_70170_p.func_201670_d() && (holder = this.getDataHolder(player)) != null && holder.isDirty()) {
                List entries = holder.gatherDirty();
                if (!entries.isEmpty()) {
                    PacketHandler.getPlayChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageSyncPlayerData(player.func_145782_y(), entries));
                    List<DataEntry<?>> syncToAllEntries = entries.stream().filter(entry -> ((DataEntry)entry).getKey().shouldSyncToAllPlayers()).collect(Collectors.toList());
                    if (!syncToAllEntries.isEmpty()) {
                        PacketHandler.getPlayChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> player), (Object)new MessageSyncPlayerData(player.func_145782_y(), syncToAllEntries));
                    }
                }
                holder.clean();
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.dirty) {
            this.dirty = false;
        }
    }

    public boolean updateMappings(HandshakeMessages.S2CSyncedPlayerData message) {
        this.idToDataKey.clear();
        Map<ResourceLocation, Integer> keyMappings = message.getKeyMap();
        for (ResourceLocation key : keyMappings.keySet()) {
            SyncedDataKey<?> syncedDataKey = this.registeredDataKeys.get(key);
            if (syncedDataKey == null) {
                return false;
            }
            int id = keyMappings.get(key);
            syncedDataKey.setId(id);
            this.idToDataKey.put(id, syncedDataKey);
        }
        return true;
    }

    static {
        init = false;
    }

    public static class Provider
    implements ICapabilitySerializable<ListNBT> {
        final LazyOptional<DataHolder> instance = LazyOptional.of(() -> CAPABILITY.getDefaultInstance());

        public ListNBT serializeNBT() {
            return (ListNBT)CAPABILITY.getStorage().writeNBT(CAPABILITY, this.instance.orElseThrow(NullPointerException::new), null);
        }

        public void deserializeNBT(ListNBT compound) {
            CAPABILITY.getStorage().readNBT(CAPABILITY, this.instance.orElseThrow(NullPointerException::new), null, (INBT)compound);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return CAPABILITY.orEmpty(cap, this.instance);
        }
    }

    public static class Storage
    implements Capability.IStorage<DataHolder> {
        @Nullable
        public INBT writeNBT(Capability<DataHolder> capability, DataHolder instance, Direction side) {
            ListNBT list = new ListNBT();
            instance.dataMap.forEach((key, entry) -> {
                if (key.shouldSave()) {
                    CompoundNBT keyTag = new CompoundNBT();
                    keyTag.func_74778_a("Key", key.getKey().toString());
                    keyTag.func_218657_a("Value", ((DataEntry)entry).writeValue());
                    list.add((Object)keyTag);
                }
            });
            return list;
        }

        public void readNBT(Capability<DataHolder> capability, DataHolder instance, Direction side, INBT nbt) {
            ListNBT list = (ListNBT)nbt;
            list.forEach(entryTag -> {
                CompoundNBT keyTag = (CompoundNBT)entryTag;
                ResourceLocation key = ResourceLocation.func_208304_a((String)keyTag.func_74779_i("Key"));
                INBT value = keyTag.func_74781_a("Value");
                SyncedDataKey syncedDataKey = (SyncedDataKey)SyncedPlayerData.instance().registeredDataKeys.get(key);
                if (syncedDataKey != null && syncedDataKey.shouldSave()) {
                    DataEntry entry = new DataEntry(syncedDataKey);
                    entry.readValue(value);
                    instance.dataMap.put(syncedDataKey, entry);
                }
            });
        }
    }

    public static class DataEntry<T> {
        private SyncedDataKey<T> key;
        private T value;
        private boolean dirty;

        private DataEntry(SyncedDataKey<T> key) {
            this.key = key;
            this.value = key.getDefaultValueSupplier().get();
        }

        private SyncedDataKey<T> getKey() {
            return this.key;
        }

        private T getValue() {
            return this.value;
        }

        private void setValue(T value, boolean dirty) {
            this.value = value;
            this.dirty = dirty;
        }

        private boolean isDirty() {
            return this.dirty;
        }

        private void clean() {
            this.dirty = false;
        }

        public void write(PacketBuffer buffer) {
            buffer.func_150787_b(this.key.getId());
            this.key.getSerializer().write(buffer, this.value);
        }

        public static DataEntry<?> read(PacketBuffer buffer) {
            SyncedDataKey key = SyncedPlayerData.instance().getKey(buffer.func_150792_a());
            Validate.notNull((Object)key, (String)"Synced key does not exist for id", (Object[])new Object[0]);
            DataEntry entry = new DataEntry(key);
            super.readValue(buffer);
            return entry;
        }

        private void readValue(PacketBuffer buffer) {
            this.value = this.getKey().getSerializer().read(buffer);
        }

        private INBT writeValue() {
            return this.key.getSerializer().write(this.value);
        }

        private void readValue(INBT nbt) {
            this.value = this.key.getSerializer().read(nbt);
        }
    }

    public static class DataHolder {
        private Map<SyncedDataKey<?>, DataEntry<?>> dataMap = new HashMap();
        private boolean dirty = false;

        private <T> boolean set(PlayerEntity player, SyncedDataKey<T> key, T value) {
            DataEntry entry = this.dataMap.computeIfAbsent(key, x$0 -> new DataEntry((SyncedDataKey)x$0));
            if (!entry.getValue().equals(value)) {
                boolean dirty = !player.field_70170_p.field_72995_K && entry.getKey().shouldSyncToClient();
                entry.setValue(value, dirty);
                this.dirty = dirty;
                return true;
            }
            return false;
        }

        @Nullable
        private <T> T get(SyncedDataKey<T> key) {
            return (T)this.dataMap.computeIfAbsent(key, x$0 -> new DataEntry((SyncedDataKey)x$0)).getValue();
        }

        private boolean isDirty() {
            return this.dirty;
        }

        private void clean() {
            this.dirty = false;
            this.dataMap.forEach((key, entry) -> ((DataEntry)entry).clean());
        }

        private List<DataEntry<?>> gatherDirty() {
            return this.dataMap.values().stream().filter(rec$ -> ((DataEntry)rec$).isDirty()).filter(entry -> ((DataEntry)entry).getKey().shouldSyncToClient()).collect(Collectors.toList());
        }

        private List<DataEntry<?>> gatherAll() {
            return this.dataMap.values().stream().filter(entry -> ((DataEntry)entry).getKey().shouldSyncToClient()).collect(Collectors.toList());
        }
    }
}

