/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.GasToGasRecipe;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.MekanismJEI;
import mekanism.common.registries.MekanismGases;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.fluid.Fluid;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;

public class FissionReactorRecipeCategory
extends BaseRecipeCategory<GasToGasRecipe> {
    private static final ResourceLocation iconRL = MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)"radioactive.png");

    public FissionReactorRecipeCategory(IGuiHelper helper) {
        super(helper, GeneratorsBlocks.FISSION_REACTOR_CASING.getRegistryName(), (ITextComponent)GeneratorsLang.FISSION_REACTOR.translate(new Object[0]), 3, 12, 189, 70);
        this.icon = helper.drawableBuilder(iconRL, 0, 0, 18, 18).setTextureSize(18, 18).build();
    }

    protected void addGuiElements() {
        this.guiElements.add(new GuiInnerScreen((IGuiWrapper)this, 45, 17, 105, 56));
        this.guiElements.add(GuiFluidGauge.getDummy((GaugeType)GaugeType.STANDARD, (IGuiWrapper)this, (int)6, (int)13).setLabel((ITextComponent)GeneratorsLang.FISSION_COOLANT_TANK.translateColored(EnumColor.AQUA, new Object[0])));
        this.guiElements.add(GuiGasGauge.getDummy((GaugeType)GaugeType.STANDARD, (IGuiWrapper)this, (int)25, (int)13).setLabel((ITextComponent)GeneratorsLang.FISSION_FUEL_TANK.translateColored(EnumColor.DARK_GREEN, new Object[0])));
        this.guiElements.add(GuiGasGauge.getDummy((GaugeType)GaugeType.STANDARD, (IGuiWrapper)this, (int)152, (int)13).setLabel((ITextComponent)GeneratorsLang.FISSION_HEATED_COOLANT_TANK.translateColored(EnumColor.GRAY, new Object[0])));
        this.guiElements.add(GuiGasGauge.getDummy((GaugeType)GaugeType.STANDARD, (IGuiWrapper)this, (int)171, (int)13).setLabel((ITextComponent)GeneratorsLang.FISSION_WASTE_TANK.translateColored(EnumColor.BROWN, new Object[0])));
    }

    private List<FluidStack> getWaterInput() {
        ArrayList<FluidStack> representations = new ArrayList<FluidStack>();
        for (Fluid fluid : FluidTags.field_206959_a.func_230236_b_()) {
            representations.add(new FluidStack(fluid, 1000));
        }
        return representations;
    }

    @Nonnull
    public Class<? extends GasToGasRecipe> getRecipeClass() {
        return GasToGasRecipe.class;
    }

    public void setIngredients(GasToGasRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(this.getWaterInput()));
        ingredients.setInputLists(MekanismJEI.TYPE_GAS, Collections.singletonList(((GasStackIngredient)recipe.getInput()).getRepresentations()));
        ingredients.setOutputs(MekanismJEI.TYPE_GAS, Arrays.asList(MekanismGases.STEAM.getStack(1000L), (GasStack)recipe.getOutputRepresentation()));
    }

    public void setRecipe(IRecipeLayout recipeLayout, GasToGasRecipe recipe, @Nonnull IIngredients ingredients) {
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        IGuiIngredientGroup gasStacks = recipeLayout.getIngredientsGroup(MekanismJEI.TYPE_GAS);
        fluidStacks.init(0, true, 7 - this.xOffset, 14 - this.yOffset, 16, 58, 1, false, this.fluidOverlayLarge);
        fluidStacks.set(0, this.getWaterInput());
        this.initChemical(gasStacks, 0, true, 26 - this.xOffset, 14 - this.yOffset, 16, 58, ((GasStackIngredient)recipe.getInput()).getRepresentations(), true);
        this.initChemical(gasStacks, 1, false, 153 - this.xOffset, 14 - this.yOffset, 16, 58, Collections.singletonList(MekanismGases.STEAM.getStack(1000L)), true);
        this.initChemical(gasStacks, 2, false, 172 - this.xOffset, 14 - this.yOffset, 16, 58, Collections.singletonList(recipe.getOutputRepresentation()), true);
    }
}

