/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.item;

import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.LongSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.chemical.item.RateLimitGasHandler;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.StorageUtils;
import mekanism.generators.common.GeneratorTags;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.registries.GeneratorsGases;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemHohlraum
extends Item {
    public ItemHohlraum(Item.Properties properties) {
        super(properties.func_200917_a(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        GasStack storedGas;
        IGasHandler gasHandlerItem;
        Optional capability;
        if (Capabilities.GAS_HANDLER_CAPABILITY != null && (capability = stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).resolve()).isPresent() && (gasHandlerItem = (IGasHandler)capability.get()).getTanks() > 0 && !(storedGas = (GasStack)gasHandlerItem.getChemicalInTank(0)).isEmpty()) {
            tooltip.add((ITextComponent)MekanismLang.STORED.translate(new Object[]{storedGas, storedGas.getAmount()}));
            if (storedGas.getAmount() == gasHandlerItem.getTankCapacity(0)) {
                tooltip.add((ITextComponent)GeneratorsLang.READY_FOR_REACTION.translateColored(EnumColor.DARK_GREEN, new Object[0]));
            } else {
                tooltip.add((ITextComponent)GeneratorsLang.INSUFFICIENT_FUEL.translateColored(EnumColor.DARK_RED, new Object[0]));
            }
            return;
        }
        tooltip.add((ITextComponent)MekanismLang.NO_GAS.translate(new Object[0]));
        tooltip.add((ITextComponent)GeneratorsLang.INSUFFICIENT_FUEL.translateColored(EnumColor.DARK_RED, new Object[0]));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return StorageUtils.getDurabilityForDisplay((ItemStack)stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return ChemicalUtil.getRGBDurabilityForDisplay((ItemStack)stack);
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> items) {
        super.func_150895_a(group, items);
        if (this.func_194125_a(group)) {
            items.add((Object)ChemicalUtil.getFilledVariant((ItemStack)new ItemStack((IItemProvider)this), (long)MekanismGeneratorsConfig.generators.hohlraumMaxGas.get(), GeneratorsGases.FUSION_FUEL));
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new ItemCapabilityWrapper(stack, new ItemCapabilityWrapper.ItemCapability[]{RateLimitGasHandler.create((LongSupplier)MekanismGeneratorsConfig.generators.hohlraumFillRate, (LongSupplier)MekanismGeneratorsConfig.generators.hohlraumMaxGas, (BiPredicate)ChemicalTankBuilder.GAS.notExternal, (BiPredicate)ChemicalTankBuilder.GAS.alwaysTrueBi, gas -> gas.isIn(GeneratorTags.Gases.FUSION_FUEL))});
    }
}

