/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.charger;

import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.BaseElectricTileEntity;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.index.CAItems;
import com.mrh0.createaddition.item.ChargingChromaticCompound;
import com.mrh0.createaddition.util.IComparatorOverride;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ChargerTileEntity
extends BaseElectricTileEntity
implements IComparatorOverride,
IHaveGoggleInformation {
    private ItemStack itemStack = ItemStack.field_190927_a;
    private static final int MAX_IN = (Integer)Config.CHARGER_MAX_INPUT.get();
    private static final int CHARGE_RATE = (Integer)Config.CHARGER_CHARGE_RATE.get();
    private static final int CAPACITY = (Integer)Config.CHARGER_CAPACITY.get();
    private int lastComparator = 0;

    public ChargerTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn, CAPACITY, MAX_IN, 0);
        this.setLazyTickRate(20);
    }

    private void chargeItem(ItemStack stack) {
        stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(itemEnergy -> {
            if (!this.isChargingItem((IEnergyStorage)itemEnergy)) {
                return;
            }
            int energyRemoved = itemEnergy.receiveEnergy(Math.min(this.energy.getEnergyStored(), CHARGE_RATE), false);
            this.energy.internalConsumeEnergy(energyRemoved);
        });
    }

    public boolean isChargingItem(IEnergyStorage energy) {
        return energy.getEnergyStored() >= 0;
    }

    public float getItemCharge(IEnergyStorage energy) {
        if (energy == null) {
            return 0.0f;
        }
        return (float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored();
    }

    @Override
    public boolean isEnergyInput(Direction side) {
        return side != Direction.UP;
    }

    @Override
    public boolean isEnergyOutput(Direction side) {
        return false;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.func_201670_d()) {
            return;
        }
        if (this.hasChargedStack()) {
            this.chargeItem(this.itemStack);
            if (this.itemStack.func_77973_b() == AllItems.CHROMATIC_COMPOUND.get()) {
                this.setChargedStack(new ItemStack((IItemProvider)CAItems.CHARGING_CHROMATIC_COMPOUND.get(), 1));
                return;
            }
            if (this.itemStack.func_77973_b() == CAItems.CHARGING_CHROMATIC_COMPOUND.get()) {
                int energyRemoved = ChargingChromaticCompound.charge(this.itemStack, Math.min(this.energy.getEnergyStored(), CHARGE_RATE));
                this.energy.internalConsumeEnergy(energyRemoved);
                if (ChargingChromaticCompound.getEnergy(this.itemStack) >= ChargingChromaticCompound.MAX_CHARGE) {
                    this.setChargedStack(new ItemStack((IItemProvider)CAItems.OVERCHARGED_ALLOY.get(), 1));
                }
                return;
            }
        }
    }

    public void lazyTick() {
        super.lazyTick();
        int comp = this.getComparetorOverride();
        if (comp != this.lastComparator) {
            this.field_145850_b.func_195593_d(this.field_174879_c, (Block)CABlocks.CHARGER.get());
        }
        this.lastComparator = comp;
        if (this.hasChargedStack()) {
            this.causeBlockUpdate();
        }
    }

    @Override
    public void fromTag(BlockState state, CompoundNBT nbt, boolean clientPacket) {
        super.fromTag(state, nbt, clientPacket);
        this.itemStack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("item"));
        if (this.itemStack == null) {
            this.itemStack = ItemStack.field_190927_a;
        }
    }

    @Override
    public void write(CompoundNBT nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        nbt.func_218657_a("item", (INBT)this.itemStack.func_77955_b(new CompoundNBT()));
    }

    public void setChargedStack(ItemStack itemStack) {
        if (itemStack == null) {
            itemStack = ItemStack.field_190927_a;
        }
        this.itemStack = itemStack.func_77946_l();
        this.itemStack.func_190920_e(1);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 0);
        this.func_70296_d();
    }

    public ItemStack getChargedStack() {
        return this.itemStack;
    }

    public boolean hasChargedStack() {
        return this.itemStack != null && !this.itemStack.func_190926_b();
    }

    @Override
    public int getComparetorOverride() {
        return (int)(this.getCharge() * 15.0f);
    }

    public float getCharge() {
        if (!this.hasChargedStack()) {
            return 0.0f;
        }
        if (this.itemStack.getCapability(CapabilityEnergy.ENERGY).isPresent()) {
            return this.getItemCharge((IEnergyStorage)this.itemStack.getCapability(CapabilityEnergy.ENERGY).orElse(null));
        }
        if (this.itemStack.func_77973_b() == CAItems.CHARGING_CHROMATIC_COMPOUND.get()) {
            return (float)ChargingChromaticCompound.getCharge(this.itemStack) * 90.0f;
        }
        if (this.itemStack.func_77973_b() == CAItems.OVERCHARGED_ALLOY.get()) {
            return 90.0f;
        }
        return 0.0f;
    }

    public String getChargeString() {
        float c = Math.round(this.getCharge() * 100.0f);
        if (c >= 9000.0f) {
            return "OVER9000% ";
        }
        return Math.round(this.getCharge() * 100.0f) + "% ";
    }

    public boolean addToGoggleTooltip(List<ITextComponent> tooltip, boolean isPlayerSneaking) {
        tooltip.add((ITextComponent)new StringTextComponent("    ").func_230529_a_((ITextComponent)new TranslationTextComponent("block.createaddition.charger.info").func_240699_a_(TextFormatting.WHITE)));
        if (this.hasChargedStack()) {
            tooltip.add((ITextComponent)new StringTextComponent("    ").func_240702_b_(" ").func_230529_a_((ITextComponent)new StringTextComponent(this.getChargeString()).func_240699_a_(TextFormatting.AQUA)).func_230529_a_((ITextComponent)new TranslationTextComponent("createaddition.tooltip.energy.charged").func_240699_a_(TextFormatting.GRAY)));
        } else {
            tooltip.add((ITextComponent)new StringTextComponent("    ").func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("block.createaddition.charger.empty").func_240699_a_(TextFormatting.GRAY)));
        }
        return true;
    }
}

